"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridBodyCustomRender = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _col_widths = require("../utils/col_widths");
var _row_heights = require("../utils/row_heights");
var _header = require("./header");
var _footer = require("./footer");
var _cell = require("./cell");
var _react2 = require("@emotion/react");
var _excluded = ["colIndex", "visibleRowIndex"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiDataGridBodyCustomRender = exports.EuiDataGridBodyCustomRender = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var renderCustomGridBody = _ref.renderCustomGridBody,
    renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    renderCellPopover = _ref.renderCellPopover,
    renderFooterCellValue = _ref.renderFooterCellValue,
    interactiveCellId = _ref.interactiveCellId,
    visibleRows = _ref.visibleRows,
    visibleColCount = _ref.visibleColCount,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    columns = _ref.columns,
    setVisibleColumns = _ref.setVisibleColumns,
    switchColumnPos = _ref.switchColumnPos,
    canDragAndDropColumns = _ref.canDragAndDropColumns,
    onColumnResize = _ref.onColumnResize,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    sorting = _ref.sorting,
    pagination = _ref.pagination,
    rowHeightsOptions = _ref.rowHeightsOptions,
    gridWidth = _ref.gridWidth,
    gridStyles = _ref.gridStyles,
    className = _ref.className;
  /**
   * Columns & widths
   */
  var visibleColumns = (0, _react.useMemo)(function () {
    return [].concat((0, _toConsumableArray2.default)(leadingControlColumns), (0, _toConsumableArray2.default)(columns), (0, _toConsumableArray2.default)(trailingControlColumns));
  }, [columns, leadingControlColumns, trailingControlColumns]);

  // compute the default column width from the container's width and count of visible columns
  var defaultColumnWidth = (0, _col_widths.useDefaultColumnWidth)(gridWidth, leadingControlColumns, trailingControlColumns, columns);
  var _useColumnWidths = (0, _col_widths.useColumnWidths)({
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      defaultColumnWidth: defaultColumnWidth,
      onColumnResize: onColumnResize
    }),
    columnWidths = _useColumnWidths.columnWidths,
    setColumnWidth = _useColumnWidths.setColumnWidth;

  /**
   * Row heights
   */
  var rowHeightUtils = (0, _row_heights.useRowHeightUtils)({
    rowHeightsOptions: rowHeightsOptions,
    columns: columns
  });
  var _useDefaultRowHeight = (0, _row_heights.useDefaultRowHeight)({
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils
    }),
    setRowHeight = _useDefaultRowHeight.setRowHeight,
    getRowHeight = _useDefaultRowHeight.getRowHeight;
  var headerRowProps = (0, _react.useMemo)(function () {
    return {
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      visibleColCount: visibleColCount,
      switchColumnPos: switchColumnPos,
      canDragAndDropColumns: canDragAndDropColumns,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      gridStyles: gridStyles
    };
  }, [leadingControlColumns, trailingControlColumns, columns, columnWidths, defaultColumnWidth, setColumnWidth, visibleColCount, setVisibleColumns, switchColumnPos, canDragAndDropColumns, sorting, schema, schemaDetectors, gridStyles]);

  /**
   * Header & footer
   */
  var _useDataGridHeader = (0, _header.useDataGridHeader)(headerRowProps),
    headerRow = _useDataGridHeader.headerRow;
  var footerRowProps = (0, _react.useMemo)(function () {
    return {
      renderFooterCellValue: renderFooterCellValue,
      renderCellPopover: renderCellPopover,
      rowIndex: visibleRows.visibleRowCount,
      visibleRowIndex: visibleRows.visibleRowCount,
      visibleColCount: visibleColCount,
      interactiveCellId: interactiveCellId,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      schema: schema,
      gridStyles: gridStyles
    };
  }, [renderFooterCellValue, renderCellPopover, visibleRows.visibleRowCount, visibleColCount, interactiveCellId, leadingControlColumns, trailingControlColumns, columns, columnWidths, defaultColumnWidth, schema, gridStyles]);
  var _useDataGridFooter = (0, _footer.useDataGridFooter)(footerRowProps),
    footerRow = _useDataGridFooter.footerRow;

  /**
   * Cell render fn
   */
  var cellProps = (0, _react.useMemo)(function () {
    return {
      schema: schema,
      schemaDetectors: schemaDetectors,
      pagination: pagination,
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      visibleColCount: visibleColCount,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      renderCellValue: renderCellValue,
      cellContext: cellContext,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      setRowHeight: setRowHeight,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      gridStyles: gridStyles
    };
  }, [schema, schemaDetectors, pagination, columns, leadingControlColumns, trailingControlColumns, visibleColCount, columnWidths, defaultColumnWidth, renderCellValue, cellContext, renderCellPopover, interactiveCellId, setRowHeight, rowHeightsOptions, rowHeightUtils, gridStyles]);
  var Cell = (0, _react.useMemo)(function () {
    return function (_ref2) {
      var _rest$rowHeightsOptio;
      var colIndex = _ref2.colIndex,
        visibleRowIndex = _ref2.visibleRowIndex,
        rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
      var style = {
        height: rowHeightUtils.isAutoHeight(visibleRowIndex, (_rest$rowHeightsOptio = rest.rowHeightsOptions) !== null && _rest$rowHeightsOptio !== void 0 ? _rest$rowHeightsOptio : rowHeightsOptions) ? 'auto' : getRowHeight(visibleRowIndex)
      };
      var props = _objectSpread({
        colIndex: colIndex,
        visibleRowIndex: visibleRowIndex,
        style: style
      }, cellProps);
      return (0, _react2.jsx)(_cell.CellWrapper, (0, _extends2.default)({}, props, rest));
    };
  }, [cellProps, getRowHeight, rowHeightUtils, rowHeightsOptions]);

  // Allow consumers to pass custom props/attributes/listeners etc. to the wrapping div
  var _useState = (0, _react.useState)({}),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    customGridBodyProps = _useState2[0],
    setCustomGridBodyProps = _useState2[1];
  var customDataGridBodyProps = (0, _react.useMemo)(function () {
    return {
      gridWidth: gridWidth,
      visibleColumns: visibleColumns,
      visibleRowData: visibleRows,
      Cell: Cell,
      setCustomGridBodyProps: setCustomGridBodyProps,
      headerRow: headerRow,
      footerRow: footerRow
    };
  }, [gridWidth, visibleColumns, visibleRows, Cell, setCustomGridBodyProps, headerRow, footerRow]);
  var BodyElement = renderCustomGridBody;
  return (0, _react2.jsx)("div", (0, _extends2.default)({}, customGridBodyProps, {
    className: (0, _classnames.default)('euiDataGrid__customRenderBody', className, customGridBodyProps === null || customGridBodyProps === void 0 ? void 0 : customGridBodyProps.className)
  }), (0, _react2.jsx)(BodyElement, customDataGridBodyProps));
});
EuiDataGridBodyCustomRender.displayName = 'EuiDataGridBodyCustomRender';