"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridBodyVirtualized = exports.DataGridWrapperRowsContext = exports.Cell = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _services = require("../../../services");
var _resize_observer = require("../../observer/resize_observer");
var _header = require("./header");
var _footer = require("./footer");
var _cell = require("./cell");
var _data_grid_row_manager = require("./data_grid_row_manager");
var _grid_height_width = require("../utils/grid_height_width");
var _col_widths = require("../utils/col_widths");
var _row_heights = require("../utils/row_heights");
var _scrolling = require("../utils/scrolling");
var _utils = require("../../../utils");
var _react2 = require("@emotion/react");
var _excluded = ["children", "style"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var Cell = exports.Cell = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var columnIndex = _ref.columnIndex,
    rowIndex = _ref.rowIndex,
    style = _ref.style,
    data = _ref.data;
  var memoizedStyles = (0, _services.useDeepEqual)(style);
  var cellStyles = (0, _react.useMemo)(function () {
    var headerRowHeight = data.headerRowHeight;
    return _objectSpread(_objectSpread({}, memoizedStyles), {}, {
      top: "".concat(parseFloat(memoizedStyles.top) + headerRowHeight, "px")
    });
  }, [memoizedStyles, data]);
  return (0, _react2.jsx)(_cell.CellWrapper, (0, _extends2.default)({
    colIndex: columnIndex,
    visibleRowIndex: rowIndex,
    style: cellStyles
  }, data));
});
Cell.displayName = 'Cell';

// Context is required to pass props to react-window's innerElementType
// @see https://github.com/bvaughn/react-window/issues/404
var DataGridWrapperRowsContext = exports.DataGridWrapperRowsContext = /*#__PURE__*/(0, _react.createContext)({
  headerRow: (0, _react2.jsx)("div", null),
  headerRowHeight: 0,
  footerRow: null
});
var InnerElement = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var children = _ref2.children,
    style = _ref2.style,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var _useContext = (0, _react.useContext)(DataGridWrapperRowsContext),
    headerRowHeight = _useContext.headerRowHeight,
    headerRow = _useContext.headerRow,
    footerRow = _useContext.footerRow;
  var memoizedStyles = (0, _services.useDeepEqual)(style);
  var innerElementStyles = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, memoizedStyles), {}, {
      height: memoizedStyles.height + headerRowHeight
    });
  }, [memoizedStyles, headerRowHeight]);
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", (0, _extends2.default)({
    ref: ref,
    style: innerElementStyles
  }, rest), headerRow, children), footerRow);
}));
InnerElement.displayName = 'EuiDataGridInnerElement';
var EuiDataGridBodyVirtualized = exports.EuiDataGridBodyVirtualized = /*#__PURE__*/(0, _react.memo)(function (_ref3) {
  var leadingControlColumns = _ref3.leadingControlColumns,
    trailingControlColumns = _ref3.trailingControlColumns,
    columns = _ref3.columns,
    visibleColCount = _ref3.visibleColCount,
    schema = _ref3.schema,
    schemaDetectors = _ref3.schemaDetectors,
    rowCount = _ref3.rowCount,
    _ref3$visibleRows = _ref3.visibleRows,
    startRow = _ref3$visibleRows.startRow,
    endRow = _ref3$visibleRows.endRow,
    visibleRowCount = _ref3$visibleRows.visibleRowCount,
    renderCellValue = _ref3.renderCellValue,
    cellContext = _ref3.cellContext,
    renderCellPopover = _ref3.renderCellPopover,
    renderFooterCellValue = _ref3.renderFooterCellValue,
    interactiveCellId = _ref3.interactiveCellId,
    pagination = _ref3.pagination,
    sorting = _ref3.sorting,
    setVisibleColumns = _ref3.setVisibleColumns,
    switchColumnPos = _ref3.switchColumnPos,
    onColumnResize = _ref3.onColumnResize,
    rowHeightsOptions = _ref3.rowHeightsOptions,
    virtualizationOptions = _ref3.virtualizationOptions,
    isFullScreen = _ref3.isFullScreen,
    gridStyles = _ref3.gridStyles,
    gridWidth = _ref3.gridWidth,
    gridRef = _ref3.gridRef,
    gridItemsRendered = _ref3.gridItemsRendered,
    wrapperRef = _ref3.wrapperRef,
    className = _ref3.className,
    canDragAndDropColumns = _ref3.canDragAndDropColumns;
  /**
   * Grid refs & observers
   */
  var wrapperDimensions = (0, _resize_observer.useResizeObserver)(wrapperRef.current);
  var outerGridRef = (0, _react.useRef)(null); // container that becomes scrollable
  var innerGridRef = (0, _react.useRef)(null); // container sized to fit all content

  /**
   * Scroll bars
   */
  var _useScrollBars = (0, _scrolling.useScrollBars)(outerGridRef, gridStyles.border),
    scrollBarHeight = _useScrollBars.scrollBarHeight,
    hasVerticalScroll = _useScrollBars.hasVerticalScroll,
    hasHorizontalScroll = _useScrollBars.hasHorizontalScroll,
    scrollBorderOverlay = _useScrollBars.scrollBorderOverlay;

  /**
   * Widths
   */
  var virtualizeContainerWidth = (0, _grid_height_width.useVirtualizeContainerWidth)(outerGridRef.current, gridWidth, pagination === null || pagination === void 0 ? void 0 : pagination.pageSize);

  // compute the default column width from the container's width and count of visible columns
  var defaultColumnWidth = (0, _col_widths.useDefaultColumnWidth)(virtualizeContainerWidth, leadingControlColumns, trailingControlColumns, columns);
  var _useColumnWidths = (0, _col_widths.useColumnWidths)({
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      defaultColumnWidth: defaultColumnWidth,
      onColumnResize: onColumnResize
    }),
    columnWidths = _useColumnWidths.columnWidths,
    setColumnWidth = _useColumnWidths.setColumnWidth,
    getColumnWidth = _useColumnWidths.getColumnWidth;

  /**
   * Header & footer
   */
  var _useDataGridHeader = (0, _header.useDataGridHeader)({
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      visibleColCount: visibleColCount,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      gridStyles: gridStyles,
      canDragAndDropColumns: canDragAndDropColumns
    }),
    headerRow = _useDataGridHeader.headerRow,
    headerRowHeight = _useDataGridHeader.headerRowHeight;
  var _useDataGridFooter = (0, _footer.useDataGridFooter)({
      renderFooterCellValue: renderFooterCellValue,
      renderCellPopover: renderCellPopover,
      rowIndex: visibleRowCount,
      visibleRowIndex: visibleRowCount,
      visibleColCount: visibleColCount,
      interactiveCellId: interactiveCellId,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      schema: schema,
      gridStyles: gridStyles
    }),
    footerRow = _useDataGridFooter.footerRow,
    footerRowHeight = _useDataGridFooter.footerRowHeight;

  /**
   * Handle scrolling cells fully into view
   */
  (0, _scrolling.useScroll)({
    gridRef: gridRef,
    outerGridRef: outerGridRef,
    hasGridScrolling: hasVerticalScroll || hasHorizontalScroll,
    headerRowHeight: headerRowHeight,
    footerRowHeight: footerRowHeight,
    visibleRowCount: visibleRowCount,
    hasStickyFooter: !!(renderFooterCellValue && gridStyles.stickyFooter),
    canDragAndDropColumns: canDragAndDropColumns
  });

  /**
   * Row manager
   */
  var rowManager = (0, _data_grid_row_manager.useRowManager)({
    innerGridRef: innerGridRef,
    rowClasses: gridStyles.rowClasses
  });

  /**
   * Heights
   */
  var rowHeightUtils = (0, _row_heights.useRowHeightUtils)({
    virtualization: {
      gridRef: gridRef,
      outerGridElementRef: outerGridRef,
      gridItemsRenderedRef: gridItemsRendered
    },
    rowHeightsOptions: rowHeightsOptions,
    columns: columns
  });
  var _useDefaultRowHeight = (0, _row_heights.useDefaultRowHeight)({
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils
    }),
    defaultRowHeight = _useDefaultRowHeight.defaultRowHeight,
    setRowHeight = _useDefaultRowHeight.setRowHeight,
    getRowHeight = _useDefaultRowHeight.getRowHeight;
  var unconstrainedHeight = (0, _grid_height_width.useUnconstrainedHeight)({
    rowHeightUtils: rowHeightUtils,
    startRow: startRow,
    endRow: endRow,
    rowHeightsOptions: rowHeightsOptions,
    defaultRowHeight: defaultRowHeight,
    headerRowHeight: headerRowHeight,
    footerRowHeight: footerRowHeight,
    scrollBarHeight: scrollBarHeight,
    innerGridRef: innerGridRef
  });

  /**
   * Final grid height & width
   */
  var _useFinalGridDimensio = (0, _grid_height_width.useFinalGridDimensions)({
      unconstrainedHeight: unconstrainedHeight,
      unconstrainedWidth: 0,
      // unable to determine this until the container's size is known
      wrapperDimensions: wrapperDimensions,
      wrapperRef: wrapperRef,
      isFullScreen: isFullScreen,
      rowCount: rowCount
    }),
    finalWidth = _useFinalGridDimensio.finalWidth,
    finalHeight = _useFinalGridDimensio.finalHeight;

  /**
   * Grid resets
   */
  (0, _react.useEffect)(function () {
    if (gridRef.current) {
      gridRef.current.resetAfterColumnIndex(0);
    }
  }, [gridRef, columns, columnWidths, defaultColumnWidth]);
  (0, _react.useEffect)(function () {
    if (gridRef.current && rowHeightsOptions) {
      gridRef.current.resetAfterRowIndex(0);
    }
  }, [gridRef, pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex, rowHeightsOptions, gridStyles === null || gridStyles === void 0 ? void 0 : gridStyles.cellPadding, gridStyles === null || gridStyles === void 0 ? void 0 : gridStyles.fontSize]);
  (0, _react.useEffect)(function () {
    if (gridRef.current) {
      gridRef.current.resetAfterRowIndex(0);
    }
  }, [gridRef, getRowHeight]);
  var onItemsRendered = (0, _react.useCallback)(function (itemsRendered) {
    var _virtualizationOption;
    gridItemsRendered.current = itemsRendered;
    virtualizationOptions === null || virtualizationOptions === void 0 || (_virtualizationOption = virtualizationOptions.onItemsRendered) === null || _virtualizationOption === void 0 || _virtualizationOption.call(virtualizationOptions, itemsRendered);
  }, [gridItemsRendered, virtualizationOptions]);
  var itemData = (0, _react.useMemo)(function () {
    return {
      schemaDetectors: schemaDetectors,
      setRowHeight: setRowHeight,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      visibleColCount: visibleColCount,
      schema: schema,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      renderCellValue: renderCellValue,
      cellContext: cellContext,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      rowManager: rowManager,
      pagination: pagination,
      headerRowHeight: headerRowHeight,
      gridStyles: gridStyles
    };
  }, [schemaDetectors, setRowHeight, leadingControlColumns, trailingControlColumns, columns, visibleColCount, schema, columnWidths, defaultColumnWidth, renderCellValue, cellContext, renderCellPopover, interactiveCellId, rowHeightsOptions, rowHeightUtils, rowManager, pagination, headerRowHeight, gridStyles]);
  var rowWrapperContextValue = (0, _react.useMemo)(function () {
    return {
      headerRowHeight: headerRowHeight,
      headerRow: headerRow,
      footerRow: footerRow
    };
  }, [headerRowHeight, headerRow, footerRow]);
  return _utils.IS_JEST_ENVIRONMENT || finalWidth > 0 ? (0, _react2.jsx)(DataGridWrapperRowsContext.Provider, {
    value: rowWrapperContextValue
  }, (0, _react2.jsx)(_reactWindow.VariableSizeGrid, (0, _extends2.default)({}, virtualizationOptions, {
    ref: gridRef,
    className: (0, _classnames.default)('euiDataGrid__virtualized', className, virtualizationOptions === null || virtualizationOptions === void 0 ? void 0 : virtualizationOptions.className),
    onItemsRendered: onItemsRendered,
    innerElementType: InnerElement,
    outerRef: outerGridRef,
    innerRef: innerGridRef,
    columnCount: visibleColCount,
    width: finalWidth,
    columnWidth: getColumnWidth,
    height: finalHeight,
    rowHeight: getRowHeight,
    itemData: itemData,
    rowCount: _utils.IS_JEST_ENVIRONMENT || headerRowHeight > 0 ? visibleRowCount : 0
  }), Cell), scrollBorderOverlay) : null;
});
EuiDataGridBodyVirtualized.displayName = 'EuiDataGridBodyVirtualized';