"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRowManager = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("react");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var useRowManager = exports.useRowManager = function useRowManager(_ref) {
  var innerGridRef = _ref.innerGridRef,
    rowClasses = _ref.rowClasses;
  var rowIdToElements = (0, _react.useRef)(new Map());
  var getRow = (0, _react.useCallback)(function (_ref2) {
    var rowIndex = _ref2.rowIndex,
      visibleRowIndex = _ref2.visibleRowIndex,
      top = _ref2.top,
      height = _ref2.height;
    var rowElement = rowIdToElements.current.get(rowIndex);
    if (rowElement == null) {
      rowElement = document.createElement('div');
      rowElement.setAttribute('role', 'row');
      rowElement.dataset.gridRowIndex = String(rowIndex); // Row index from data, not affected by sorting/pagination
      rowElement.classList.add('euiDataGridRow');
      if (rowClasses !== null && rowClasses !== void 0 && rowClasses[rowIndex]) {
        var _rowElement$classList;
        (_rowElement$classList = rowElement.classList).add.apply(_rowElement$classList, (0, _toConsumableArray2.default)(rowClasses[rowIndex].split(' ')));
      }
      rowElement.style.position = 'absolute';
      rowElement.style.left = '0';
      rowElement.style.right = '0';

      // In order for the rowElement's left and right position to correctly inherit
      // from the innerGrid width, we need to make its position relative
      innerGridRef.current.style.position = 'relative';

      // add the element to the grid
      innerGridRef.current.appendChild(rowElement);

      // add the element to the row map
      rowIdToElements.current.set(rowIndex, rowElement);

      // watch the row's children, if they all disappear then remove this row
      var observer = new MutationObserver(function (records) {
        if (records[0].target.childElementCount === 0) {
          var _rowElement;
          observer.disconnect();
          (_rowElement = rowElement) === null || _rowElement === void 0 || _rowElement.remove();
          rowIdToElements.current.delete(rowIndex);
        }
      });
      observer.observe(rowElement, {
        childList: true
      });
    }

    // Ensure the row's visible row index & striping update correctly on sort & pagination
    if (rowElement.dataset.gridVisibleRowIndex !== String(visibleRowIndex)) {
      rowElement.dataset.gridVisibleRowIndex = String(visibleRowIndex);
      var isOddRow = visibleRowIndex % 2 !== 0;
      if (isOddRow) {
        rowElement.classList.add('euiDataGridRow--striped');
      } else {
        rowElement.classList.remove('euiDataGridRow--striped');
      }
    }

    // Ensure that the row's dimensions are always correct by having each cell update position styles
    rowElement.style.top = top;
    rowElement.style.height = "".concat(height, "px");
    return rowElement;
  }, [rowClasses, innerGridRef]);

  // Update row classes dynamically whenever a new prop is passed in
  (0, _services.useUpdateEffect)(function () {
    if (rowClasses) {
      rowIdToElements.current.forEach(function (rowElement, rowIndex) {
        var euiClasses = Array.from(rowElement.classList).filter(function (className) {
          return ['euiDataGridRow', 'euiDataGridRow--striped'].includes(className);
        }).join(' ');
        if (rowClasses[rowIndex]) {
          rowElement.classList.value = "".concat(euiClasses, " ").concat(rowClasses[rowIndex]);
        } else {
          rowElement.classList.value = euiClasses; // Clear any added classes
        }
      });
    }
  }, [rowClasses]);
  return (0, _react.useMemo)(function () {
    return {
      getRow: getRow
    };
  }, [getRow]);
};