"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classnames2 = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _icon = require("../../../icon");
var _column_actions = require("./column_actions");
var _column_sorting = require("./column_sorting");
var _draggable_columns = require("./draggable_columns");
var _column_resizer = require("./column_resizer");
var _data_grid_header_cell_wrapper = require("./data_grid_header_cell_wrapper");
var _data_grid_header_cell = require("./data_grid_header_cell.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiDataGridHeaderCell = exports.EuiDataGridHeaderCell = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var index = _ref.index,
    column = _ref.column,
    columns = _ref.columns,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    setColumnWidth = _ref.setColumnWidth,
    setVisibleColumns = _ref.setVisibleColumns,
    switchColumnPos = _ref.switchColumnPos,
    isLastColumn = _ref.isLastColumn,
    sorting = _ref.sorting,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    canDragAndDropColumns = _ref.canDragAndDropColumns,
    gridStyles = _ref.gridStyles;
  var id = column.id,
    display = column.display,
    displayAsText = column.displayAsText,
    displayHeaderCellProps = column.displayHeaderCellProps,
    actions = column.actions;
  var title = displayAsText || id;
  var children = display || displayAsText || id;
  var width = columnWidths[id] || defaultColumnWidth;
  var columnType = schema[id] ? schema[id].columnType : null;
  var hasColumnActions = (0, _column_actions.useHasColumnActions)(actions);
  var classes = (0, _classnames2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, "euiDataGridHeaderCell--".concat(columnType), columnType), 'euiDataGridHeaderCell--hasColumnActions', hasColumnActions), displayHeaderCellProps === null || displayHeaderCellProps === void 0 ? void 0 : displayHeaderCellProps.className);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_header_cell.euiDataGridHeaderCellStyles);
  var contentStyles = [styles.euiDataGridHeaderCell__content, (columnType === 'numeric' || columnType === 'currency') && styles.right];

  // Props passed from <ColumnActions /> to be set on <EuiDataGridHeaderCellWrapper />
  var _useState = (0, _react.useState)({}),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    propsFromColumnActions = _useState2[0],
    setPropsFromColumnActions = _useState2[1];
  var actionsButtonRef = (0, _react.useRef)(null);
  var _useColumnSorting = (0, _column_sorting.useColumnSorting)({
      sorting: sorting,
      id: id,
      hasColumnActions: hasColumnActions
    }),
    sortingArrow = _useColumnSorting.sortingArrow,
    ariaSort = _useColumnSorting.ariaSort,
    sortingAriaId = _useColumnSorting.sortingAriaId,
    sortingScreenReaderText = _useColumnSorting.sortingScreenReaderText;
  var columnResizer = (0, _react.useMemo)(function () {
    return column.isResizable !== false && width != null ? (0, _react2.jsx)(_column_resizer.EuiDataGridColumnResizer, {
      columnId: id,
      columnWidth: width,
      setColumnWidth: setColumnWidth,
      isLastColumn: isLastColumn
    }) : null;
  }, [column.isResizable, id, width, setColumnWidth, isLastColumn]);
  return (0, _react2.jsx)(_draggable_columns.ConditionalDraggableColumn, {
    id: id,
    index: index,
    canDragAndDropColumns: !!canDragAndDropColumns,
    gridStyles: gridStyles,
    columnResizer: columnResizer,
    actionsPopoverToggle: actionsButtonRef.current
  }, function (dragProps) {
    return (0, _react2.jsx)(_data_grid_header_cell_wrapper.EuiDataGridHeaderCellWrapper, (0, _extends2.default)({}, displayHeaderCellProps, dragProps, {
      hasColumnActions: hasColumnActions
    }, propsFromColumnActions, {
      className: (0, _classnames2.default)(classes, propsFromColumnActions.className),
      id: id,
      index: index,
      isLastColumn: isLastColumn,
      width: width,
      "aria-sort": ariaSort,
      "aria-label": displayAsText && "".concat(displayAsText, ", ") // ensure cell text content is read first, if available
      ,
      "aria-describedby": (0, _classnames2.default)(sortingAriaId, dragProps === null || dragProps === void 0 ? void 0 : dragProps['aria-describedby']),
      "data-column-moving": propsFromColumnActions['data-column-moving'] || (dragProps === null || dragProps === void 0 ? void 0 : dragProps['data-column-moving']) || undefined
    }), function (hasFocusTrap) {
      return (0, _react2.jsx)(_react.default.Fragment, null, !canDragAndDropColumns && columnResizer, canDragAndDropColumns && (0, _react2.jsx)("span", {
        className: "euiDataGridHeaderCell__draggableIcon"
      }, (0, _react2.jsx)(_icon.EuiIcon, {
        type: "grabOmnidirectional",
        size: "s",
        css: styles.euiDataGridHeaderCell__actions
      })), (0, _react2.jsx)("div", {
        css: contentStyles,
        className: "euiDataGridHeaderCell__content",
        title: title
      }, children), sortingArrow, sortingScreenReaderText, hasColumnActions && (0, _react2.jsx)(_column_actions.ColumnActions, {
        index: index,
        id: id,
        title: title,
        column: column,
        columns: columns,
        schema: schema,
        schemaDetectors: schemaDetectors,
        setVisibleColumns: setVisibleColumns,
        switchColumnPos: switchColumnPos,
        sorting: sorting,
        hasFocusTrap: hasFocusTrap,
        setPropsFromColumnActions: setPropsFromColumnActions,
        actionsButtonRef: actionsButtonRef
      }));
    });
  });
});
EuiDataGridHeaderCell.displayName = 'EuiDataGridHeaderCell';