"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridColumnSorting = exports.DataGridSortingControl = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _button = require("../../button");
var _drag_and_drop = require("../../drag_and_drop");
var _flex = require("../../flex");
var _i18n = require("../../i18n");
var _popover = require("../../popover");
var _text = require("../../text");
var _token = require("../../token");
var _data_grid_schema = require("../utils/data_grid_schema");
var _data_grid_toolbar_control = require("./data_grid_toolbar_control");
var _column_sorting_draggable = require("./column_sorting_draggable");
var _column_sorting = require("./column_sorting.styles");
var _react2 = require("@emotion/react");
var _excluded = ["sorting"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var useDataGridColumnSorting = exports.useDataGridColumnSorting = function useDataGridColumnSorting(_ref) {
  var sorting = _ref.sorting,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return sorting == null ? null : (0, _react2.jsx)(DataGridSortingControl, (0, _extends2.default)({
    sorting: sorting
  }, rest));
};
var DataGridSortingControl = exports.DataGridSortingControl = /*#__PURE__*/(0, _react.memo)(function (_ref2) {
  var columns = _ref2.columns,
    sorting = _ref2.sorting,
    schema = _ref2.schema,
    schemaDetectors = _ref2.schemaDetectors,
    displayValues = _ref2.displayValues;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var sortingButtonText = (0, _i18n.useEuiI18n)('euiColumnSorting.button', 'Sort fields');
  var sortFieldAriaLabel = (0, _i18n.useEuiI18n)('euiColumnSorting.sortFieldAriaLabel', 'Sort by: ');
  var styles = (0, _services.useEuiMemoizedStyles)(_column_sorting.euiDataGridColumnSortingStyles);
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    availableColumnsIsOpen = _useState4[0],
    setAvailableColumnsIsOpen = _useState4[1];
  var availableColumnIds = (0, _react.useMemo)(function () {
    return new Set(columns.map(function (_ref3) {
      var id = _ref3.id;
      return id;
    }));
  }, [columns]);

  // prune any non-existent/hidden columns from sorting
  (0, _react.useEffect)(function () {
    var nextSortingColumns = [];
    for (var i = 0; i < sorting.columns.length; i++) {
      var column = sorting.columns[i];
      if (availableColumnIds.has(column.id)) {
        nextSortingColumns.push(column);
      }
    }

    // if the column array lengths differ then the sorting columns have been pruned
    if (nextSortingColumns.length !== sorting.columns.length) {
      sorting.onSort(nextSortingColumns);
    }
  }, [availableColumnIds, sorting]);
  var _useMemo = (0, _react.useMemo)(function () {
      var activeColumnIds = new Set(sorting.columns.map(function (_ref4) {
        var id = _ref4.id;
        return id;
      }));
      return columns.reduce(function (acc, column) {
        if (activeColumnIds.has(column.id)) {
          acc.activeColumns.push(column);
        } else {
          acc.inactiveColumns.push(column);
        }
        return acc;
      }, {
        activeColumns: [],
        inactiveColumns: []
      });
    }, [columns, sorting]),
    inactiveColumns = _useMemo.inactiveColumns;
  var onDragEnd = (0, _react.useCallback)(function (_ref5) {
    var sourceIndex = _ref5.source.index,
      destination = _ref5.destination;
    if (destination) {
      var destinationIndex = destination.index;
      var nextColumns = (0, _drag_and_drop.euiDragDropReorder)(sorting.columns, sourceIndex, destinationIndex);
      sorting.onSort(nextColumns);
    }
  }, [sorting]);
  var schemaDetails = (0, _react.useCallback)(function (id) {
    return schema.hasOwnProperty(id) && schema[id].columnType != null ? (0, _data_grid_schema.getDetailsForSchema)(schemaDetectors, schema[id].columnType) : null;
  }, [schema, schemaDetectors]);
  var inactiveSortableColumns = (0, _react.useMemo)(function () {
    return inactiveColumns.filter(function (_ref6) {
      var id = _ref6.id,
        isSortable = _ref6.isSortable;
      var schemaDetail = schemaDetails(id);
      var sortable = true;
      if (isSortable != null) {
        sortable = isSortable;
      } else if (schemaDetail != null) {
        sortable = schemaDetail.hasOwnProperty('isSortable') ? schemaDetail.isSortable : true;
      }
      return sortable;
    });
  }, [inactiveColumns, schemaDetails]);
  var onButtonClick = (0, _react.useCallback)(function (id, defaultSortDirection) {
    var _schemaDetails;
    var nextColumns = (0, _toConsumableArray2.default)(sorting.columns);
    nextColumns.push({
      id: id,
      direction: defaultSortDirection || ((_schemaDetails = schemaDetails(id)) === null || _schemaDetails === void 0 ? void 0 : _schemaDetails.defaultSortDirection) || 'asc'
    });
    sorting.onSort(nextColumns);
  }, [sorting, schemaDetails]);
  return (0, _react2.jsx)(_popover.EuiPopover, {
    "data-test-subj": "dataGridColumnSortingPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downLeft",
    panelPaddingSize: "s",
    button: (0, _react2.jsx)(_data_grid_toolbar_control.EuiDataGridToolbarControl, {
      badgeContent: sorting.columns.length,
      iconType: "sortable",
      "data-test-subj": "dataGridColumnSortingButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      }
    }, sortingButtonText)
  }, sorting.columns.length > 0 ? (0, _react2.jsx)(_drag_and_drop.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, (0, _react2.jsx)(_drag_and_drop.EuiDroppable, {
    droppableId: "columnSorting",
    css: styles.euiDataGridColumnSorting
  }, (0, _react2.jsx)(_react.default.Fragment, null, sorting.columns.map(function (_ref7, index) {
    var id = _ref7.id,
      direction = _ref7.direction;
    return (0, _react2.jsx)(_column_sorting_draggable.EuiDataGridColumnSortingDraggable, {
      key: id,
      id: id,
      display: displayValues[id],
      direction: direction,
      index: index,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors
    });
  })))) : (0, _react2.jsx)(_text.EuiText, {
    size: "s",
    color: "subdued"
  }, (0, _react2.jsx)("p", {
    role: "alert"
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiColumnSorting.emptySorting",
    default: "Currently no fields are sorted"
  }))), (inactiveSortableColumns.length > 0 || sorting.columns.length > 0) && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, inactiveSortableColumns.length > 0 && (0, _react2.jsx)(_popover.EuiPopover, {
    "data-test-subj": "dataGridColumnSortingPopoverColumnSelection",
    isOpen: availableColumnsIsOpen,
    closePopover: function closePopover() {
      return setAvailableColumnsIsOpen(false);
    },
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    button: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      iconType: "arrowDown",
      iconSide: "right",
      "data-test-subj": "dataGridColumnSortingSelectionButton",
      onClick: function onClick() {
        return setAvailableColumnsIsOpen(!availableColumnsIsOpen);
      }
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSorting.pickFields",
      default: "Pick fields to sort by"
    }))
  }, (0, _react2.jsx)("div", {
    css: styles.euiDataGridColumnSorting__fieldList,
    className: "euiDataGridColumnSorting__fieldList",
    role: "listbox"
  }, inactiveSortableColumns.map(function (_ref8) {
    var id = _ref8.id,
      defaultSortDirection = _ref8.defaultSortDirection;
    return (0, _react2.jsx)("button", {
      key: id,
      css: styles.euiDataGridColumnSorting__field,
      className: "euiDataGridColumnSorting__field",
      "aria-label": "".concat(sortFieldAriaLabel, " ").concat(id),
      role: "option",
      "aria-selected": "false",
      "data-test-subj": "dataGridColumnSortingPopoverColumnSelection-".concat(id),
      onClick: function onClick() {
        return onButtonClick(id, defaultSortDirection);
      }
    }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      component: "span",
      responsive: false
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_token.EuiToken, {
      iconType: schemaDetails(id) != null ? (0, _data_grid_schema.getDetailsForSchema)(schemaDetectors, schema[id].columnType).icon : 'tokenString',
      color: schemaDetails(id) != null ? (0, _data_grid_schema.getDetailsForSchema)(schemaDetectors, schema[id].columnType).color : undefined
    })), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_text.EuiText, {
      size: "xs"
    }, displayValues[id]))));
  })))), sorting.columns.length > 0 ? (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: function onClick() {
      return sorting.onSort([]);
    },
    "data-test-subj": "dataGridColumnSortingClearButton"
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiColumnSorting.clearAll",
    default: "Clear sorting"
  }))) : null)));
});
DataGridSortingControl.displayName = 'DataGridSortingControl';