"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSortDescLabel = exports.defaultSortAscLabel = exports.EuiDataGridColumnSortingDraggable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _button = require("../../button");
var _drag_and_drop = require("../../drag_and_drop");
var _flex = require("../../flex");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _text = require("../../text");
var _token = require("../../token");
var _data_grid_schema = require("../utils/data_grid_schema");
var _column_sorting = require("./column_sorting.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "display", "direction", "index", "sorting", "schema", "schemaDetectors"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var defaultSortAscLabel = exports.defaultSortAscLabel = (0, _react2.jsx)(_i18n.EuiI18n, {
  token: "euiColumnSortingDraggable.defaultSortAsc",
  default: "A-Z"
});
var defaultSortDescLabel = exports.defaultSortDescLabel = (0, _react2.jsx)(_i18n.EuiI18n, {
  token: "euiColumnSortingDraggable.defaultSortDesc",
  default: "Z-A"
});
var EuiDataGridColumnSortingDraggable = exports.EuiDataGridColumnSortingDraggable = function EuiDataGridColumnSortingDraggable(_ref) {
  var id = _ref.id,
    display = _ref.display,
    direction = _ref.direction,
    index = _ref.index,
    sorting = _ref.sorting,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var schemaDetails = schema.hasOwnProperty(id) && schema[id].columnType != null ? (0, _data_grid_schema.getDetailsForSchema)(schemaDetectors, schema[id].columnType) : null;
  var textSortAsc = schemaDetails != null ? schemaDetails.sortTextAsc : defaultSortAscLabel;
  var textSortDesc = schemaDetails != null ? schemaDetails.sortTextDesc : defaultSortDescLabel;
  var toggleOptions = [{
    id: "".concat(id, "Asc"),
    value: 'asc',
    label: textSortAsc,
    'data-test-subj': "euiDataGridColumnSorting-sortColumn-".concat(id, "-asc")
  }, {
    id: "".concat(id, "Desc"),
    value: 'desc',
    label: textSortDesc,
    'data-test-subj': "euiDataGridColumnSorting-sortColumn-".concat(id, "-desc")
  }];
  var dragHandleAriaLabel = (0, _i18n.useEuiI18n)('euiColumnSortingDraggable.dragHandleAriaLabel', 'Drag handle');
  var removeSort = (0, _react.useCallback)(function () {
    var nextColumns = (0, _toConsumableArray2.default)(sorting.columns);
    var columnIndex = nextColumns.map(function (_ref2) {
      var id = _ref2.id;
      return id;
    }).indexOf(id);
    nextColumns.splice(columnIndex, 1);
    sorting.onSort(nextColumns);
  }, [id, sorting]);
  var toggleLegendHandler = (0, _react.useCallback)(function (_, direction) {
    var nextColumns = (0, _toConsumableArray2.default)(sorting.columns);
    var columnIndex = nextColumns.map(function (_ref3) {
      var id = _ref3.id;
      return id;
    }).indexOf(id);
    nextColumns.splice(columnIndex, 1, {
      id: id,
      direction: direction
    });
    sorting.onSort(nextColumns);
  }, [id, sorting]);
  var styles = (0, _services.useEuiMemoizedStyles)(_column_sorting.euiDataGridColumnSortingStyles);
  return (0, _react2.jsx)(_drag_and_drop.EuiDraggable, (0, _extends2.default)({
    draggableId: id,
    index: index,
    hasInteractiveChildren: true,
    customDragHandle: true,
    usePortal: true
  }, rest), function (provided, state) {
    return (0, _react2.jsx)(_flex.EuiFlexGroup, {
      css: styles.euiDataGridColumnSorting__item,
      className: (0, _classnames.default)('euiDataGridColumnSorting__item', {
        'euiDataGridColumnSorting__item-isDragging': state.isDragging
      }),
      gutterSize: "xs",
      alignItems: "center",
      responsive: false,
      "data-test-subj": "euiDataGridColumnSorting-sortColumn-".concat(id)
    }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSortingDraggable.activeSortLabel",
      default: "{display} is sorting this data grid",
      values: {
        display: display
      }
    }, function (activeSortLabel) {
      return activeSortLabel;
    }))), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSortingDraggable.removeSortLabel",
      default: "Remove {display} from data grid sort",
      values: {
        display: display
      }
    }, function (removeSortLabel) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, {
        color: "text",
        className: "euiDataGridColumnSorting__button",
        "aria-label": removeSortLabel,
        iconType: "cross",
        onClick: removeSort
      });
    })), (0, _react2.jsx)(_flex.EuiFlexItem
    // This extra column name flex item affords the column more grabbable real estate
    // for mouse users, while hiding repetition for keyboard/screen reader users
    , (0, _extends2.default)({
      css: styles.euiDataGridColumnSorting__name,
      className: "euiDataGridColumnSorting__name"
    }, provided.dragHandleProps, {
      tabIndex: -1,
      "aria-hidden": true
    }), (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_token.EuiToken, {
      color: schemaDetails != null ? schemaDetails.color : undefined,
      iconType: schemaDetails != null ? schemaDetails.icon : 'tokenString'
    })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_text.EuiText, {
      size: "xs"
    }, display)))), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSortingDraggable.toggleLegend",
      default: "Select sorting method for {display}",
      values: {
        display: display
      }
    }, function (toggleLegend) {
      return (0, _react2.jsx)(_button.EuiButtonGroup, {
        legend: toggleLegend,
        isFullWidth: true,
        options: toggleOptions,
        buttonSize: "compressed",
        css: styles.euiDataGridColumnSorting__order,
        className: "euiDataGridColumnSorting__order",
        idSelected: direction === 'asc' ? "".concat(id, "Asc") : "".concat(id, "Desc"),
        onChange: toggleLegendHandler
      });
    })), (0, _react2.jsx)(_flex.EuiFlexItem, (0, _extends2.default)({
      grow: false
    }, provided.dragHandleProps, {
      "aria-label": dragHandleAriaLabel
    }), (0, _react2.jsx)(_icon.EuiIcon, {
      type: "grab",
      color: "subdued"
    })));
  });
};