"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInMemoryValues = exports.EuiDataGridInMemoryRenderer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _react2 = require("../../../services/react");
var _mutation_observer = require("../../observer/mutation_observer");
var _react3 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * inMemory values hook
 */
var useInMemoryValues = exports.useInMemoryValues = function useInMemoryValues(inMemory, rowCount) {
  /**
   * For performance, `onCellRender` below mutates the inMemoryValues object
   * instead of cloning. If this operation were done in a setState call
   * React would ignore the update as the object itself has not changed.
   * So, we keep a dual record: the in-memory values themselves and a "version" counter.
   * When the object is mutated, the version is incremented triggering a re-render, and
   * the returned `inMemoryValues` object is re-created (cloned) from the mutated version.
   * The version updates are batched, so only one clone happens per batch.
   **/
  var _inMemoryValues = (0, _react.useRef)({});
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    inMemoryValuesVersion = _useState2[0],
    setInMemoryValuesVersion = _useState2[1];
  var inMemoryValues = (0, _react.useMemo)(function () {
    return _objectSpread({}, _inMemoryValues.current);
  }, [inMemoryValuesVersion] // eslint-disable-line react-hooks/exhaustive-deps
  );
  var onCellRender = (0, _react.useCallback)(function (rowIndex, columnId, value) {
    var nextInMemoryValues = _inMemoryValues.current;
    nextInMemoryValues[rowIndex] = nextInMemoryValues[rowIndex] || {};
    if (nextInMemoryValues[rowIndex][columnId] !== value) {
      nextInMemoryValues[rowIndex][columnId] = value;
      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, []);

  // if `inMemory.level` or `rowCount` changes reset the values
  var inMemoryLevel = inMemory && inMemory.level;
  var resetRunCount = (0, _react.useRef)(0);
  (0, _react.useEffect)(function () {
    if (resetRunCount.current++ > 0) {
      // this has to delete "overflow" keys from the object instead of resetting to an empty one,
      // as the internal inmemoryrenderer component's useEffect which sets the values
      // executes before this outer, wrapping useEffect
      var existingRowKeyCount = Object.keys(_inMemoryValues.current).length;
      for (var i = rowCount; i < existingRowKeyCount; i++) {
        delete _inMemoryValues.current[i];
      }
      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, [inMemoryLevel, rowCount]);
  return [inMemoryValues, onCellRender];
};

/**
 * InMemory renderer
 */
var EuiDataGridInMemoryRenderer = exports.EuiDataGridInMemoryRenderer = function EuiDataGridInMemoryRenderer(_ref) {
  var inMemory = _ref.inMemory,
    columns = _ref.columns,
    rowCount = _ref.rowCount,
    renderCellValue = _ref.renderCellValue,
    onCellRender = _ref.onCellRender;
  var _useState3 = (0, _react.useState)(function () {
      return document.createDocumentFragment();
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 1),
    documentFragment = _useState4[0];
  var cells = (0, _react.useMemo)(function () {
    var CellElement = renderCellValue;
    var cells = [];
    var _loop = function _loop(i) {
      cells.push(columns.map(function (column, j) {
        var skipThisColumn = inMemory.skipColumns && inMemory.skipColumns.indexOf(column.id) !== -1;
        if (skipThisColumn) {
          return null;
        }
        var isExpandable = column.isExpandable !== undefined ? column.isExpandable : true;
        return (0, _react3.jsx)("div", {
          key: "".concat(i, "-").concat(column.id),
          "data-dg-row": i,
          "data-dg-column": column.id
        }, (0, _react3.jsx)(CellElement, {
          rowIndex: i,
          colIndex: j,
          columnId: column.id,
          setCellProps: noop,
          schema: column.schema,
          isExpandable: isExpandable,
          isExpanded: false,
          isDetails: false
        }));
      }).filter(function (cell) {
        return cell != null;
      }));
    };
    for (var i = 0; i < rowCount; i++) {
      _loop(i);
    }
    return cells;
  }, [rowCount, columns, inMemory.skipColumns, renderCellValue]);
  var onMutation = (0, _react.useCallback)(function (records) {
    var _loop2 = function _loop2() {
      var record = records[i];
      var target = record.target;
      while (true) {
        if (target == null) return 1; // continue recordLoop
        // somehow hit the document fragment
        if (target.nodeType === Node.ELEMENT_NODE && target.hasAttribute('data-dg-row')) {
          // target is the cell wrapping div
          break;
        }
        target = target.parentElement;
      }
      var cellDiv = target;
      var rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);
      var column = cellDiv.getAttribute('data-dg-column');
      (0, _react2.enqueueStateChange)(function () {
        return onCellRender(rowIndex, column, getElementText(cellDiv));
      });
    };
    recordLoop: for (var i = 0; i < records.length; i++) {
      if (_loop2()) continue recordLoop;
    }
  }, [onCellRender]);
  (0, _react.useEffect)(function () {
    var cellDivs = documentFragment.childNodes[0].childNodes;
    for (var i = 0; i < cellDivs.length; i++) {
      var cellDiv = cellDivs[i];
      var rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);
      var column = cellDiv.getAttribute('data-dg-column');
      onCellRender(rowIndex, column, getElementText(cellDiv));
    }
    // changes to documentFragment.children is reflected by `cells`
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onCellRender, cells]);
  return /*#__PURE__*/(0, _reactDom.createPortal)((0, _react3.jsx)(_mutation_observer.EuiMutationObserver, {
    onMutation: onMutation,
    observerOptions: {
      characterData: true,
      subtree: true,
      attributes: true,
      childList: true
    }
  }, function (ref) {
    return (0, _react3.jsx)("div", {
      ref: ref
    }, cells);
  }), documentFragment);
};
function noop() {}
function getElementText(element) {
  return 'innerText' in element ? element.innerText :
  // (this line left here to satisfy Prettier since a ts-ignore is used on the next line)
  // @ts-ignore TypeScript thinks element.innerText always exists, however it doesn't in jest/jsdom environment
  element.textContent || '';
}