"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRefreshInterval = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _flex = require("../../flex");
var _form = require("../../form");
var _accessibility = require("../../accessibility");
var _time_options = require("../super_date_picker/time_options");
var _quick_select_panel = require("../super_date_picker/quick_select_popover/quick_select_panel");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var MILLISECONDS_IN_SECOND = 1000;
var MILLISECONDS_IN_MINUTE = MILLISECONDS_IN_SECOND * 60;
var MILLISECONDS_IN_HOUR = MILLISECONDS_IN_MINUTE * 60;
var fromMilliseconds = function fromMilliseconds(milliseconds, unit) {
  var round = function round(value) {
    return parseFloat(value.toFixed(2));
  };
  if (unit === 'h' || !unit && milliseconds > MILLISECONDS_IN_HOUR) {
    return {
      units: 'h',
      value: round(milliseconds / MILLISECONDS_IN_HOUR)
    };
  }
  if (unit === 'm' || !unit && milliseconds > MILLISECONDS_IN_MINUTE) {
    return {
      units: 'm',
      value: round(milliseconds / MILLISECONDS_IN_MINUTE)
    };
  }
  return {
    units: 's',
    value: round(milliseconds / MILLISECONDS_IN_SECOND)
  };
};
var toMilliseconds = function toMilliseconds(units, value) {
  switch (units) {
    case 'h':
      return Math.round(value * MILLISECONDS_IN_HOUR);
    case 'm':
      return Math.round(value * MILLISECONDS_IN_MINUTE);
    case 's':
    default:
      return Math.round(value * MILLISECONDS_IN_SECOND);
  }
};
var getMinInterval = function getMinInterval(minInterval, unit) {
  if (!minInterval) return 0;
  var _fromMilliseconds = fromMilliseconds(minInterval, unit),
    value = _fromMilliseconds.value;
  return Math.floor(value || 0);
};
var EuiRefreshInterval = exports.EuiRefreshInterval = /*#__PURE__*/function (_Component) {
  function EuiRefreshInterval() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiRefreshInterval);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiRefreshInterval, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", _objectSpread(_objectSpread({}, fromMilliseconds(_this.props.refreshInterval || 0, _this.props.intervalUnits)), {}, {
      min: getMinInterval(_this.props.minInterval, _this.props.intervalUnits)
    }));
    (0, _defineProperty2.default)(_this, "generateId", (0, _services.htmlIdGenerator)());
    (0, _defineProperty2.default)(_this, "refreshSelectionId", _this.generateId());
    (0, _defineProperty2.default)(_this, "onValueChange", function (event) {
      var sanitizedValue = parseFloat(event.target.value);
      _this.setState({
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }, _this.applyRefreshInterval);
    });
    (0, _defineProperty2.default)(_this, "onUnitsChange", function (event) {
      var units = event.target.value;
      _this.setState({
        units: units,
        min: getMinInterval(_this.props.minInterval, units)
      }, _this.applyRefreshInterval);
    });
    (0, _defineProperty2.default)(_this, "startRefresh", function () {
      var onRefreshChange = _this.props.onRefreshChange;
      var _this$state = _this.state,
        value = _this$state.value,
        units = _this$state.units;
      if (value !== '' && value > 0 && onRefreshChange !== undefined) {
        onRefreshChange({
          refreshInterval: toMilliseconds(units, value),
          intervalUnits: units,
          isPaused: false
        });
      }
    });
    (0, _defineProperty2.default)(_this, "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.startRefresh();
      }
    });
    (0, _defineProperty2.default)(_this, "applyRefreshInterval", function () {
      var _this$props = _this.props,
        onRefreshChange = _this$props.onRefreshChange,
        isPaused = _this$props.isPaused,
        minInterval = _this$props.minInterval;
      var _this$state2 = _this.state,
        units = _this$state2.units,
        value = _this$state2.value;
      if (value === '') {
        return;
      }
      if (!onRefreshChange) {
        return;
      }
      var refreshInterval = Math.max(toMilliseconds(units, value), minInterval || 0);
      onRefreshChange({
        refreshInterval: refreshInterval,
        intervalUnits: units,
        isPaused: refreshInterval <= 0 ? true : !!isPaused
      });
    });
    (0, _defineProperty2.default)(_this, "toggleRefresh", function () {
      var _this$props2 = _this.props,
        onRefreshChange = _this$props2.onRefreshChange,
        isPaused = _this$props2.isPaused;
      var _this$state3 = _this.state,
        units = _this$state3.units,
        value = _this$state3.value;
      if (!onRefreshChange || value === '') {
        return;
      }
      onRefreshChange({
        refreshInterval: toMilliseconds(units, value),
        intervalUnits: units,
        isPaused: !isPaused
      });
    });
    (0, _defineProperty2.default)(_this, "renderScreenReaderText", function (refreshUnitsOptions) {
      var isPaused = _this.props.isPaused;
      var _this$state4 = _this.state,
        value = _this$state4.value,
        units = _this$state4.units;
      var options = refreshUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === units;
      });
      var optionText = options ? options.text : '';
      var fullDescription = isPaused ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOff",
        default: "Refresh is off, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOn",
        default: "Refresh is on, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      });
      return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
        id: _this.refreshSelectionId
      }, fullDescription));
    });
    return _this;
  }
  (0, _inherits2.default)(EuiRefreshInterval, _Component);
  return (0, _createClass2.default)(EuiRefreshInterval, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var isPaused = this.props.isPaused;
      var _this$state5 = this.state,
        value = _this$state5.value,
        units = _this$state5.units,
        min = _this$state5.min;
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        tokens: ['euiRefreshInterval.toggleLabel', 'euiRefreshInterval.toggleAriaLabel', 'euiRefreshInterval.valueAriaLabel', 'euiRefreshInterval.unitsAriaLabel'],
        defaults: ['Refresh every', 'Toggle refresh', 'Refresh interval value', 'Refresh interval units']
      }, function (_ref3) {
        var _ref4 = (0, _slicedToArray2.default)(_ref3, 4),
          toggleLabel = _ref4[0],
          toggleAriaLabel = _ref4[1],
          valueAriaLabel = _ref4[2],
          unitsAriaLabel = _ref4[3];
        return (0, _react2.jsx)(_time_options.RenderI18nTimeOptions, null, function (_ref5) {
          var refreshUnitsOptions = _ref5.refreshUnitsOptions;
          return (0, _react2.jsx)(_quick_select_panel.EuiQuickSelectPanel, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "s",
            responsive: false,
            wrap: true
          }, (0, _react2.jsx)(_flex.EuiFlexItem, {
            grow: false
          }, (0, _react2.jsx)(_form.EuiSwitch, {
            "data-test-subj": "superDatePickerToggleRefreshButton",
            checked: !isPaused,
            onChange: _this2.toggleRefresh,
            compressed: true
            // The IDs attached to this visible label are unused - we override with our own aria-label
            ,
            label: (0, _react2.jsx)(_form.EuiFormLabel, null, toggleLabel),
            "aria-label": toggleAriaLabel,
            "aria-labelledby": undefined,
            "aria-describedby": _this2.refreshSelectionId
          })), (0, _react2.jsx)(_flex.EuiFlexItem, {
            style: {
              minWidth: 60
            }
          }, (0, _react2.jsx)(_form.EuiFieldNumber, {
            compressed: true,
            fullWidth: true,
            value: value,
            min: min,
            onChange: _this2.onValueChange,
            onKeyDown: _this2.handleKeyDown,
            isInvalid: !isPaused && (value === '' || value <= 0),
            disabled: isPaused,
            "aria-label": valueAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            "data-test-subj": "superDatePickerRefreshIntervalInput"
          })), (0, _react2.jsx)(_flex.EuiFlexItem, {
            style: {
              minWidth: 100
            },
            grow: 2
          }, (0, _react2.jsx)(_form.EuiSelect, {
            compressed: true,
            fullWidth: true,
            "aria-label": unitsAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            value: units,
            disabled: isPaused,
            options: refreshUnitsOptions,
            onChange: _this2.onUnitsChange,
            onKeyDown: _this2.handleKeyDown,
            "data-test-subj": "superDatePickerRefreshIntervalUnitsSelect"
          }))), _this2.renderScreenReaderText(refreshUnitsOptions));
        });
      });
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiRefreshInterval, "defaultProps", {
  isPaused: true,
  refreshInterval: 1000,
  minInterval: 0
});