"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _date_picker = require("./date_picker");
var _form = require("../form");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var DatePicker = function DatePicker() {
  var _useState = (0, _react.useState)((0, _moment.default)()),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    startDate = _useState2[0],
    setStartDate = _useState2[1];
  var handleChange = function handleChange(date) {
    setStartDate(date);
  };
  return (0, _react2.jsx)(_form.EuiFormRow, {
    label: "Select a date"
  }, (0, _react2.jsx)(_date_picker.EuiDatePicker, {
    selected: startDate,
    onChange: handleChange
  }));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(DatePicker, null));
  cy.get('input.euiDatePicker').should('exist');
});
describe('EuiDatePicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the calendar widget is expanded', function () {
      cy.get('input.euiDatePicker').realClick();
      cy.get('div.react-datepicker').should('exist');
      cy.checkAxe();
    });
    it('has zero violations after picking a date with arrow keys', function () {
      cy.realPress('Tab');
      cy.get('div.react-datepicker').should('exist');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('ArrowRight');
      cy.realPress('Enter');
      cy.get('div.react-datepicker').should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations after picking a date with dropdown menus', function () {
      cy.realPress('Tab');
      cy.get('div.react-datepicker').should('exist');
      cy.repeatRealPress('Tab', 4);
      cy.get('div.react-datepicker__month-read-view').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.checkAxe();
    });
  });
});