"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _icon = require("../../../icon");
var _month_dropdown_options = _interopRequireDefault(require("./month_dropdown_options"));
var utils = _interopRequireWildcard(require("./date_utils"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2018 HackerOne Inc and individual contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
var MonthDropdown = exports.default = /*#__PURE__*/function (_React$Component) {
  function MonthDropdown(props) {
    var _this;
    (0, _classCallCheck2.default)(this, MonthDropdown);
    _this = _callSuper(this, MonthDropdown, [props]);
    (0, _defineProperty2.default)(_this, "setReadViewRef", function (ref) {
      _this.readViewref = ref;
      _this.props.buttonRef(ref);
    });
    (0, _defineProperty2.default)(_this, "onReadViewKeyDown", function (event) {
      var eventKey = event.key;
      switch (eventKey) {
        case " ":
        case "Enter":
          event.preventDefault();
          event.stopPropagation();
          _this.toggleDropdown();
          break;
      }
    });
    (0, _defineProperty2.default)(_this, "onDropDownKeyDown", function (event) {
      var eventKey = event.key;
      switch (eventKey) {
        case " ":
        case "Enter":
          event.preventDefault();
          event.stopPropagation();
          _this.toggleDropdown();
          break;
      }
    });
    (0, _defineProperty2.default)(_this, "renderSelectOptions", function (monthNames) {
      return monthNames.map(function (M, i) {
        return (0, _react2.jsx)("option", {
          key: i,
          value: i
        }, M);
      });
    });
    (0, _defineProperty2.default)(_this, "renderSelectMode", function (monthNames) {
      return (0, _react2.jsx)("select", {
        value: _this.props.month,
        className: "react-datepicker__month-select",
        onChange: function onChange(e) {
          return _this.onChange(e.target.value);
        }
      }, _this.renderSelectOptions(monthNames));
    });
    (0, _defineProperty2.default)(_this, "renderReadView", function (visible, monthNames) {
      return (0, _react2.jsx)("div", {
        key: "read",
        ref: _this.setReadViewRef,
        style: {
          visibility: visible ? "visible" : "hidden"
        },
        className: "react-datepicker__month-read-view",
        onClick: _this.toggleDropdown,
        onKeyDown: _this.onReadViewKeyDown,
        tabIndex: _this.props.accessibleMode ? "0" : undefined,
        "aria-label": "Button. Open the month selector. ".concat(monthNames[_this.props.month], " is currently selected.")
      }, (0, _react2.jsx)("span", {
        className: "react-datepicker__month-read-view--selected-month"
      }, monthNames[_this.props.month]), (0, _react2.jsx)(_icon.EuiIcon, {
        type: "arrowDown",
        size: "s",
        color: "subdued",
        className: "react-datepicker__month-read-view--down-arrow"
      }));
    });
    (0, _defineProperty2.default)(_this, "renderDropdown", function (monthNames) {
      return (0, _react2.jsx)(_month_dropdown_options.default, {
        key: "dropdown",
        ref: "options",
        month: _this.props.month,
        monthNames: monthNames,
        onChange: _this.onChange,
        onCancel: _this.toggleDropdown,
        accessibleMode: _this.props.accessibleMode
      });
    });
    (0, _defineProperty2.default)(_this, "renderScrollMode", function (monthNames) {
      var dropdownVisible = _this.state.dropdownVisible;
      var result = [_this.renderReadView(!dropdownVisible, monthNames)];
      if (dropdownVisible) {
        result.unshift(_this.renderDropdown(monthNames));
      }
      return result;
    });
    (0, _defineProperty2.default)(_this, "onChange", function (month) {
      _this.toggleDropdown();
      if (month !== _this.props.month) {
        _this.props.onChange(month);
      }
    });
    (0, _defineProperty2.default)(_this, "toggleDropdown", function () {
      var isOpen = !_this.state.dropdownVisible;
      _this.setState({
        dropdownVisible: isOpen
      });
      _this.props.onDropdownToggle(isOpen, 'month');
    });
    _this.localeData = utils.getLocaleDataForLocale(_this.props.locale);
    _this.monthNames = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11].map(_this.props.useShortMonthInDropdown ? function (M) {
      return utils.getMonthShortInLocale(_this.localeData, utils.newDate({
        M: M
      }));
    } : function (M) {
      return utils.getMonthInLocale(_this.localeData, utils.newDate({
        M: M
      }), _this.props.dateFormat);
    });
    _this.state = {
      dropdownVisible: false
    };
    return _this;
  }
  (0, _inherits2.default)(MonthDropdown, _React$Component);
  return (0, _createClass2.default)(MonthDropdown, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var _this2 = this;
      if (this.props.accessibleMode &&
      // in accessibleMode
      prevState.dropdownVisible !== this.state.dropdownVisible &&
      // dropdown visibility changed
      this.state.dropdownVisible === false // dropdown is no longer visible
      ) {
        this.readViewref.focus();
      }
      if (prevProps.locale !== this.props.locale) {
        this.localeData = utils.getLocaleDataForLocale(this.props.locale);
        this.monthNames = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11].map(this.props.useShortMonthInDropdown ? function (M) {
          return utils.getMonthShortInLocale(_this2.localeData, utils.newDate({
            M: M
          }));
        } : function (M) {
          return utils.getMonthInLocale(_this2.localeData, utils.newDate({
            M: M
          }), _this2.props.dateFormat);
        });
        this.forceUpdate();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var renderedDropdown;
      switch (this.props.dropdownMode) {
        case "scroll":
          renderedDropdown = this.renderScrollMode(this.monthNames);
          break;
        case "select":
          renderedDropdown = this.renderSelectMode(this.monthNames);
          break;
      }
      return (0, _react2.jsx)("div", {
        className: "react-datepicker__month-dropdown-container react-datepicker__month-dropdown-container--".concat(this.props.dropdownMode)
      }, renderedDropdown);
    }
  }]);
}(_react.default.Component);
(0, _defineProperty2.default)(MonthDropdown, "propTypes", {
  dropdownMode: _propTypes.default.oneOf(["scroll", "select"]).isRequired,
  locale: _propTypes.default.string,
  dateFormat: _propTypes.default.string.isRequired,
  month: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func.isRequired,
  useShortMonthInDropdown: _propTypes.default.bool,
  accessibleMode: _propTypes.default.bool,
  onDropdownToggle: _propTypes.default.func,
  buttonRef: _propTypes.default.func
});
module.exports = exports.default;