"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _date_utils = require("./date_utils");
var _focus_trap = require("../../../focus_trap");
var _accessibility = require("../../../accessibility");
var _react2 = require("@emotion/react");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2018 HackerOne Inc and individual contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
function generateMonthYears(minDate, maxDate) {
  var list = [];
  var currDate = (0, _date_utils.getStartOfMonth)((0, _date_utils.cloneDate)(minDate));
  var lastDate = (0, _date_utils.getStartOfMonth)((0, _date_utils.cloneDate)(maxDate));
  while (!(0, _date_utils.isAfter)(currDate, lastDate)) {
    list.push((0, _date_utils.cloneDate)(currDate));
    (0, _date_utils.addMonths)(currDate, 1);
  }
  return list;
}
var MonthYearDropdownOptions = exports.default = /*#__PURE__*/function (_React$Component) {
  function MonthYearDropdownOptions(props) {
    var _this;
    (0, _classCallCheck2.default)(this, MonthYearDropdownOptions);
    _this = _callSuper(this, MonthYearDropdownOptions, [props]);
    (0, _defineProperty2.default)(_this, "renderOptions", function () {
      return _this.state.monthYearsList.map(function (monthYear) {
        var monthYearPoint = monthYear.valueOf();
        var isSameMonthYear = (0, _date_utils.isSameYear)(_this.props.date, monthYear) && (0, _date_utils.isSameMonth)(_this.props.date, monthYear);
        var isPreselectionSameMonthYear = (0, _date_utils.isSameYear)(_this.state.preSelection, monthYear) && (0, _date_utils.isSameMonth)(_this.state.preSelection, monthYear);
        return (0, _react2.jsx)("div", {
          className: (0, _classnames.default)("react-datepicker__month-year-option", {
            "--selected_month-year": isSameMonthYear,
            "react-datepicker__month-year-option--preselected": _this.props.accessibleMode && isPreselectionSameMonthYear
          }),
          key: monthYearPoint,
          ref: function ref(div) {
            if (_this.props.accessibleMode && isPreselectionSameMonthYear) {
              _this.preSelectionDiv = div;
            }
          },
          onClick: _this.onChange.bind(_this, monthYearPoint)
        }, isSameMonthYear ? (0, _react2.jsx)("span", {
          className: "react-datepicker__month-year-option--selected"
        }, "\u2713") : "", (0, _date_utils.formatDate)(monthYear, _this.props.dateFormat));
      });
    });
    (0, _defineProperty2.default)(_this, "onFocus", function () {
      if (_this.props.accessibleMode) {
        _this.setState({
          readInstructions: true
        });
      }
    });
    (0, _defineProperty2.default)(_this, "onChange", function (monthYear) {
      return _this.props.onChange(monthYear);
    });
    (0, _defineProperty2.default)(_this, "handleClickOutside", function () {
      _this.props.onCancel();
    });
    (0, _defineProperty2.default)(_this, "onInputKeyDown", function (event) {
      var eventKey = event.key;
      var newSelection;
      switch (eventKey) {
        case "ArrowUp":
          event.preventDefault();
          event.stopPropagation();
          newSelection = (0, _date_utils.addMonths)((0, _date_utils.cloneDate)(_this.state.preSelection), -1);
          break;
        case "ArrowDown":
          event.preventDefault();
          event.stopPropagation();
          newSelection = (0, _date_utils.addMonths)((0, _date_utils.cloneDate)(_this.state.preSelection), 1);
          break;
        case "Escape":
          event.preventDefault();
          event.stopPropagation();
          _this.props.onCancel();
          break;
        case " ":
        case "Enter":
          event.preventDefault();
          event.stopPropagation();
          _this.props.onChange(_this.state.preSelection.valueOf());
          break;
      }
      if (newSelection) {
        var minMonthYear = _this.state.monthYearsList[0];
        var maxMonthYear = _this.state.monthYearsList[_this.state.monthYearsList.length - 1];
        if ((0, _date_utils.isBefore)(newSelection, minMonthYear)) newSelection = maxMonthYear;
        if ((0, _date_utils.isAfter)(newSelection, maxMonthYear)) newSelection = minMonthYear;
        _this.setState({
          preSelection: newSelection
        });
      }
    });
    _this.state = {
      monthYearsList: generateMonthYears(_this.props.minDate, _this.props.maxDate),
      preSelection: (0, _date_utils.getStartOfMonth)((0, _date_utils.cloneDate)(_this.props.date)),
      readInstructions: false
    };
    return _this;
  }
  (0, _inherits2.default)(MonthYearDropdownOptions, _React$Component);
  return (0, _createClass2.default)(MonthYearDropdownOptions, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.preSelectionDiv) {
        this.preSelectionDiv.scrollIntoView({
          behavior: "instant",
          block: "nearest",
          inline: "nearest"
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.preSelectionDiv) {
        this.preSelectionDiv.scrollIntoView({
          behavior: "instant",
          block: "nearest",
          inline: "nearest"
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var dropdownClass = (0, _classnames.default)({
        "react-datepicker__month-year-dropdown": true,
        "react-datepicker__month-year-dropdown--scrollable": this.props.scrollableMonthYearDropdown
      });
      var screenReaderInstructions;
      if (this.state.readInstructions) {
        screenReaderInstructions = (0, _react2.jsx)("p", {
          "aria-live": true
        }, "You are focused on a month / year selector menu. Use the up and down arrows to select a month / year combination, then hit enter to confirm your selection.", (0, _date_utils.formatDate)(this.state.preSelection, this.props.dateFormat), " is the currently focused month / year.");
      }
      return this.props.accessibleMode ? (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
        onClickOutside: this.handleClickOutside
      }, (0, _react2.jsx)("div", {
        className: dropdownClass,
        tabIndex: "0",
        onKeyDown: this.onInputKeyDown,
        onFocus: this.onFocus
      }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, screenReaderInstructions)), this.renderOptions())) : (0, _react2.jsx)("div", {
        className: dropdownClass
      }, this.renderOptions());
      return (0, _react2.jsx)("div", {
        className: dropdownClass
      }, this.renderOptions());
    }
  }]);
}(_react.default.Component);
(0, _defineProperty2.default)(MonthYearDropdownOptions, "propTypes", {
  minDate: _propTypes.default.object.isRequired,
  maxDate: _propTypes.default.object.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onChange: _propTypes.default.func.isRequired,
  scrollableMonthYearDropdown: _propTypes.default.bool,
  date: _propTypes.default.object.isRequired,
  dateFormat: _propTypes.default.string.isRequired,
  accessibleMode: _propTypes.default.bool
});
module.exports = exports.default;