"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePopoverContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../../services");
var _global_styling = require("../../../../global_styling");
var _i18n = require("../../../i18n");
var _tabs = require("../../../tabs");
var _text = require("../../../text");
var _button = require("../../../button");
var _date_modes = require("../date_modes");
var _absolute_tab = require("./absolute_tab");
var _relative_tab = require("./relative_tab");
var _date_popover_content = require("./date_popover_content.styles");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiDatePopoverContent = exports.EuiDatePopoverContent = function EuiDatePopoverContent(_ref) {
  var value = _ref.value,
    _ref$canRoundRelative = _ref.canRoundRelativeUnits,
    canRoundRelativeUnits = _ref$canRoundRelative === void 0 ? true : _ref$canRoundRelative,
    _ref$roundUp = _ref.roundUp,
    roundUp = _ref$roundUp === void 0 ? false : _ref$roundUp,
    onChange = _ref.onChange,
    dateFormat = _ref.dateFormat,
    timeFormat = _ref.timeFormat,
    locale = _ref.locale,
    position = _ref.position,
    utcOffset = _ref.utcOffset,
    timeOptions = _ref.timeOptions,
    minDate = _ref.minDate,
    maxDate = _ref.maxDate;
  var styles = (0, _services.useEuiMemoizedStyles)(_date_popover_content.euiDatePopoverContentStyles);
  var onTabClick = function onTabClick(selectedTab) {
    switch (selectedTab.id) {
      case _date_modes.DATE_MODES.ABSOLUTE:
        onChange((0, _date_modes.toAbsoluteString)(value, roundUp));
        break;
      case _date_modes.DATE_MODES.RELATIVE:
        onChange((0, _date_modes.toRelativeString)(value));
        break;
    }
  };
  var startDateLabel = (0, _i18n.useEuiI18n)('euiDatePopoverContent.startDateLabel', 'Start date');
  var endDateLabel = (0, _i18n.useEuiI18n)('euiDatePopoverContent.endDateLabel', 'End date');
  var labelPrefix = position === 'start' ? startDateLabel : endDateLabel;
  var absoluteLabel = (0, _i18n.useEuiI18n)('euiDatePopoverContent.absoluteTabLabel', 'Absolute');
  var relativeLabel = (0, _i18n.useEuiI18n)('euiDatePopoverContent.relativeTabLabel', 'Relative');
  var nowLabel = (0, _i18n.useEuiI18n)('euiDatePopoverContent.nowTabLabel', 'Now');
  var renderTabs = [{
    id: _date_modes.DATE_MODES.ABSOLUTE,
    name: absoluteLabel,
    content: (0, _react2.jsx)(_absolute_tab.EuiAbsoluteTab, {
      dateFormat: dateFormat,
      timeFormat: timeFormat,
      locale: locale,
      value: value,
      onChange: onChange,
      roundUp: roundUp,
      labelPrefix: labelPrefix,
      utcOffset: utcOffset,
      minDate: minDate,
      maxDate: maxDate
    }),
    'data-test-subj': 'superDatePickerAbsoluteTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(absoluteLabel)
  }, {
    id: _date_modes.DATE_MODES.RELATIVE,
    name: relativeLabel,
    content: (0, _react2.jsx)(_relative_tab.EuiRelativeTab, {
      dateFormat: dateFormat,
      locale: locale,
      value: canRoundRelativeUnits ? (0, _date_modes.toAbsoluteString)(value, roundUp) : value,
      onChange: onChange,
      roundUp: roundUp,
      labelPrefix: labelPrefix,
      timeOptions: timeOptions
    }),
    'data-test-subj': 'superDatePickerRelativeTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(relativeLabel)
  }, {
    id: _date_modes.DATE_MODES.NOW,
    name: nowLabel,
    content: (0, _react2.jsx)(_text.EuiText, {
      size: "s",
      color: "subdued",
      css: (0, _global_styling.useEuiPaddingCSS)().m
    }, (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiDatePopoverContent.nowTabContent",
      default: "Setting the time to \"now\" means that on every refresh this time will be set to the time of the refresh."
    })), (0, _react2.jsx)(_button.EuiButton, {
      "data-test-subj": "superDatePickerNowButton",
      onClick: function onClick() {
        onChange('now');
      },
      fullWidth: true,
      size: "s",
      fill: true
    }, position === 'start' ? (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiDatePopoverContent.nowTabButtonStart",
      default: "Set start date and time to now"
    }) : (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiDatePopoverContent.nowTabButtonEnd",
      default: "Set end date and time to now"
    }))),
    'data-test-subj': 'superDatePickerNowTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(nowLabel)
  }];
  var initialSelectedTab = renderTabs.find(function (tab) {
    return tab.id === (0, _date_modes.getDateMode)(value);
  });
  return (0, _react2.jsx)(_tabs.EuiTabbedContent, {
    css: styles.euiDatePopoverContent,
    className: "euiDatePopoverContent",
    tabs: renderTabs,
    autoFocus: "selected",
    initialSelectedTab: initialSelectedTab,
    onTabClick: onTabClick,
    size: "s",
    expand: true
  });
};
EuiDatePopoverContent.displayName = 'EuiDatePopoverContent';