"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRelativeTab = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _global_styling = require("../../../../global_styling");
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _accessibility = require("../../../accessibility");
var _flex = require("../../../flex");
var _form = require("../../../form");
var _popover = require("../../../popover");
var _spacer = require("../../../spacer");
var _date_modes = require("../date_modes");
var _relative_utils = require("../relative_utils");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRelativeTab = exports.EuiRelativeTab = function EuiRelativeTab(_ref) {
  var _ref$timeOptions = _ref.timeOptions,
    relativeOptions = _ref$timeOptions.relativeOptions,
    relativeRoundingLabels = _ref$timeOptions.relativeRoundingLabels,
    dateFormat = _ref.dateFormat,
    locale = _ref.locale,
    value = _ref.value,
    onChange = _ref.onChange,
    roundUp = _ref.roundUp,
    labelPrefix = _ref.labelPrefix;
  var initialRelativeParts = (0, _react.useRef)((0, _relative_utils.parseRelativeParts)(value));
  var roundUnit = initialRelativeParts.current.roundUnit;
  var _useState = (0, _react.useState)(initialRelativeParts.current.unit),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    unit = _useState2[0],
    setUnit = _useState2[1];
  var onUnitChange = (0, _react.useCallback)(function (event) {
    setUnit(event.target.value);
  }, []);
  var _useState3 = (0, _react.useState)(initialRelativeParts.current.round),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    round = _useState4[0],
    setRound = _useState4[1];
  var onRoundChange = (0, _react.useCallback)(function (event) {
    setRound(event.target.checked);
  }, []);
  var _useState5 = (0, _react.useState)(initialRelativeParts.current.count),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    count = _useState6[0],
    setCount = _useState6[1];
  var onCountChange = (0, _react.useCallback)(function (event) {
    var sanitizedValue = parseInt(event.target.value, 10);
    var count = isNaN(sanitizedValue) ? undefined : sanitizedValue;
    setCount(count);
  }, []);
  (0, _services.useUpdateEffect)(function () {
    if (count === undefined || count < 0) return;
    var date = (0, _relative_utils.toRelativeStringFromParts)({
      count: count,
      round: !!round,
      roundUnit: roundUnit,
      unit: unit
    });
    onChange(date);
  }, [onChange, count, round, roundUnit, unit]);
  var invalidDate = value === _date_modes.INVALID_DATE;
  var invalidValue = count === undefined || count < 0;
  var isInvalid = invalidValue || invalidDate;
  var formattedValue = (0, _react.useMemo)(function () {
    if (isInvalid) return '';
    var parsedValue = _datemath.default.parse(value, {
      roundUp: roundUp
    });
    if (!parsedValue || !parsedValue.isValid()) return '';
    return parsedValue.locale(locale || 'en').format(dateFormat);
  }, [isInvalid, value, roundUp, locale, dateFormat]);
  var relativeDateInputNumberDescriptionId = (0, _services.useGeneratedHtmlId)();
  var numberAriaLabel = (0, _i18n.useEuiI18n)('euiRelativeTab.numberInputLabel', 'Time span amount');
  var numberInputError = (0, _i18n.useEuiI18n)('euiRelativeTab.numberInputError', 'Must be >= 0');
  var dateInputError = (0, _i18n.useEuiI18n)('euiRelativeTab.dateInputError', 'Must be a valid range');
  var unitSelectAriaLabel = (0, _i18n.useEuiI18n)('euiRelativeTab.unitInputLabel', 'Relative time span');
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_form.EuiForm, {
    css: (0, _global_styling.useEuiPaddingCSS)().s
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiFormRow, {
    isInvalid: isInvalid,
    error: invalidValue ? numberInputError : invalidDate ? dateInputError : null
  }, (0, _react2.jsx)(_form.EuiFieldNumber, {
    compressed: true,
    "aria-label": numberAriaLabel,
    "aria-describedby": relativeDateInputNumberDescriptionId,
    "data-test-subj": "superDatePickerRelativeDateInputNumber",
    value: count,
    onChange: onCountChange,
    isInvalid: isInvalid
  }))), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiSelect, {
    compressed: true,
    "aria-label": unitSelectAriaLabel,
    "data-test-subj": "superDatePickerRelativeDateInputUnitSelector",
    value: unit,
    options: relativeOptions,
    onChange: onUnitChange
  }))), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), (0, _react2.jsx)(_form.EuiFieldText, {
    compressed: true,
    value: formattedValue,
    readOnly: true,
    prepend: (0, _react2.jsx)(_form.EuiFormLabel, null, labelPrefix)
  }), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    id: relativeDateInputNumberDescriptionId
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiRelativeTab.fullDescription",
    default: "The unit is changeable. Currently set to {unit}.",
    values: {
      unit: unit
    }
  })))), (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    paddingSize: "s"
  }, (0, _react2.jsx)(_form.EuiSwitch, {
    "data-test-subj": "superDatePickerRelativeDateRoundSwitch",
    label: relativeRoundingLabels[unit.substring(0, 1)],
    checked: !!round,
    onChange: onRoundChange
  })));
};