"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelectPopover = exports.EuiQuickSelectPanels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _button = require("../../../button");
var _icon = require("../../../icon");
var _popover = require("../../../popover");
var _quick_select_popover = require("./quick_select_popover.styles");
var _quick_select_panel = require("./quick_select_panel");
var _quick_select = require("./quick_select");
var _commonly_used_time_ranges = require("./commonly_used_time_ranges");
var _recently_used = require("./recently_used");
var _refresh_interval = require("../../auto_refresh/refresh_interval");
var _react2 = require("@emotion/react");
var _excluded = ["applyTime"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiQuickSelectPopover = exports.EuiQuickSelectPopover = function EuiQuickSelectPopover(_ref) {
  var _applyTime = _ref.applyTime,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prevQuickSelect = _useState2[0],
    setQuickSelect = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setIsOpen(false);
  }, []);
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var applyTime = (0, _react.useCallback)(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end,
      quickSelect = _ref2.quickSelect,
      _ref2$keepPopoverOpen = _ref2.keepPopoverOpen,
      keepPopoverOpen = _ref2$keepPopoverOpen === void 0 ? false : _ref2$keepPopoverOpen;
    _applyTime({
      start: start,
      end: end
    });
    if (quickSelect) {
      setQuickSelect(quickSelect);
    }
    if (!keepPopoverOpen) {
      closePopover();
    }
  }, [_applyTime, closePopover]);
  var buttonlabel = (0, _i18n.useEuiI18n)('euiQuickSelectPopover.buttonLabel', 'Date quick select');
  var styles = (0, _services.useEuiMemoizedStyles)(_quick_select_popover.euiQuickSelectPopoverStyles);
  var quickSelectButton = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    css: styles.euiQuickSelectPopoverButton,
    contentProps: {
      css: styles.euiQuickSelectPopoverButton__content
    },
    onClick: togglePopover,
    "aria-label": buttonlabel,
    title: buttonlabel,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    isDisabled: props.isDisabled,
    "data-test-subj": "superDatePickerToggleQuickMenuButton"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "calendar"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    button: quickSelectButton,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft"
  }, (0, _react2.jsx)(EuiQuickSelectPanels, (0, _extends2.default)({}, props, {
    applyTime: applyTime,
    prevQuickSelect: prevQuickSelect
  })));
};
var EuiQuickSelectPanels = exports.EuiQuickSelectPanels = function EuiQuickSelectPanels(_ref3) {
  var start = _ref3.start,
    end = _ref3.end,
    dateFormat = _ref3.dateFormat,
    timeOptions = _ref3.timeOptions,
    commonlyUsedRanges = _ref3.commonlyUsedRanges,
    recentlyUsedRanges = _ref3.recentlyUsedRanges,
    customQuickSelectPanels = _ref3.customQuickSelectPanels,
    customQuickSelectRender = _ref3.customQuickSelectRender,
    isPaused = _ref3.isPaused,
    refreshInterval = _ref3.refreshInterval,
    refreshMinInterval = _ref3.refreshMinInterval,
    intervalUnits = _ref3.intervalUnits,
    applyRefreshInterval = _ref3.applyRefreshInterval,
    applyTime = _ref3.applyTime,
    prevQuickSelect = _ref3.prevQuickSelect;
  var styles = (0, _services.useEuiMemoizedStyles)(_quick_select_popover.euiQuickSelectPopoverStyles);
  var quickSelectElement = (0, _react2.jsx)(_quick_select.EuiQuickSelect, {
    applyTime: applyTime,
    start: start,
    end: end,
    prevQuickSelect: prevQuickSelect,
    timeOptions: timeOptions
  });
  var commonlyUsedElement = (0, _react2.jsx)(_commonly_used_time_ranges.EuiCommonlyUsedTimeRanges, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges
  });
  var recentlyUsedElement = (0, _react2.jsx)(_recently_used.EuiRecentlyUsed, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges,
    dateFormat: dateFormat,
    recentlyUsedRanges: recentlyUsedRanges
  });
  var refreshIntervalElement = applyRefreshInterval && (0, _react2.jsx)(_refresh_interval.EuiRefreshInterval, {
    onRefreshChange: applyRefreshInterval,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: refreshMinInterval,
    intervalUnits: intervalUnits
  });
  var customQuickSelectPanelsElement = (0, _react.useMemo)(function () {
    if (!customQuickSelectPanels) {
      return null;
    }
    return customQuickSelectPanels.map(function (_ref4) {
      var title = _ref4.title,
        content = _ref4.content;
      return (0, _react2.jsx)(_quick_select_panel.EuiQuickSelectPanel, {
        key: title,
        title: title
      }, /*#__PURE__*/_react.default.cloneElement(content, {
        applyTime: applyTime
      }));
    });
  }, [customQuickSelectPanels, applyTime]);
  return (0, _react2.jsx)("div", {
    css: styles.euiQuickSelectPopover,
    className: "euiQuickSelectPopover",
    "data-test-subj": "superDatePickerQuickMenu"
  }, customQuickSelectRender ? customQuickSelectRender({
    quickSelect: quickSelectElement,
    commonlyUsedRanges: commonlyUsedElement,
    recentlyUsedRanges: recentlyUsedElement,
    refreshInterval: refreshIntervalElement,
    customQuickSelectPanels: customQuickSelectPanelsElement
  }) : (0, _react2.jsx)(_react.default.Fragment, null, quickSelectElement, commonlyUsedElement, recentlyUsedElement, refreshIntervalElement, customQuickSelectPanelsElement));
};