"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _delay_render = require("./delay_render");
var _form = require("../form");
var _flex = require("../flex");
var _loading = require("../loading");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var DelayRender = function DelayRender() {
  var _useState = (0, _react.useState)(1000),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    minimumDelay = _useState2[0],
    setDelay = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    render = _useState4[0],
    setRender = _useState4[1];
  var status = render ? 'showing' : 'hidden';
  var label = "Child (".concat(status, ")");
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiFormRow, null, (0, _react2.jsx)(_form.EuiCheckbox, {
    id: "dummy-id",
    checked: render,
    onChange: function onChange(event) {
      return setRender(event.target.checked);
    },
    label: "Show child"
  })), (0, _react2.jsx)(_form.EuiFormRow, {
    label: "Minimum delay"
  }, (0, _react2.jsx)(_form.EuiFieldNumber, {
    value: minimumDelay,
    onChange: function onChange(event) {
      return setDelay(parseInt(event.target.value, 10));
    }
  })), (0, _react2.jsx)(_form.EuiFormRow, {
    label: label
  }, render ? (0, _react2.jsx)(_delay_render.EuiDelayRender, {
    delay: minimumDelay
  }, (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
    size: "m"
  })) : (0, _react2.jsx)(_react.default.Fragment, null))));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(DelayRender, null));
});
describe('EuiDelayRender', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the show child input is checked', function () {
      cy.get('input.euiCheckbox__input').realClick();
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('exist');
      cy.checkAxe();
    });
    it('has zero violations when the show child input is pressed', function () {
      cy.realPress('Tab');
      cy.get('input.euiCheckbox__input').should('have.focus');
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('exist');
      cy.checkAxe();
    });
    it('has zero violations when the show child input is toggled', function () {
      cy.realPress('Tab');
      cy.get('input.euiCheckbox__input').should('have.focus');
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      });
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('not.exist');
      cy.checkAxe();
    });
  });
});