"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescriptionList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _description_list_context = require("./description_list_context");
var _description_list_title = require("./description_list_title");
var _description_list_description = require("./description_list_description");
var _description_list = require("./description_list.styles");
var _react2 = require("@emotion/react");
var _excluded = ["align", "children", "className", "style", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type", "rowGutterSize", "columnGutterSize", "columnWidths"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiDescriptionList = exports.EuiDescriptionList = function EuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    _type = _ref$type === void 0 ? 'row' : _ref$type,
    _ref$rowGutterSize = _ref.rowGutterSize,
    rowGutterSize = _ref$rowGutterSize === void 0 ? 's' : _ref$rowGutterSize,
    _ref$columnGutterSize = _ref.columnGutterSize,
    columnGutterSize = _ref$columnGutterSize === void 0 ? 's' : _ref$columnGutterSize,
    columnWidths = _ref.columnWidths,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var showResponsiveColumns = (0, _services.useIsWithinBreakpoints)(['xs', 's']);
  var type = (0, _react.useMemo)(function () {
    if (_type === 'responsiveColumn') {
      return showResponsiveColumns ? 'row' : 'column';
    } else {
      return _type;
    }
  }, [_type, showResponsiveColumns]);
  var styles = (0, _services.useEuiMemoizedStyles)(_description_list.euiDescriptionListStyles);
  var cssStyles = [styles.euiDescriptionList, styles[type], styles[align], type === 'column' && styles.rowGap[rowGutterSize], type === 'column' && styles.columnGap[columnGutterSize]];
  var inlineStyles = (0, _react.useMemo)(function () {
    if (type === 'column' && columnWidths) {
      // Leave string values as is - e.g. if a consumer passes in a specific '200px' or 'minmax()'
      var convertNumbersToFr = function convertNumbersToFr(value) {
        return typeof value === 'number' ? "".concat(value, "fr") : value;
      };
      var titleWidth = convertNumbersToFr(columnWidths[0]);
      var descriptionWidth = convertNumbersToFr(columnWidths[1]);
      return _objectSpread({
        gridTemplateColumns: "".concat(titleWidth, " ").concat(descriptionWidth)
      }, style);
    }
    return style;
  }, [style, type, columnWidths]);
  var classes = (0, _classnames.default)('euiDescriptionList', className);
  var renderedListItems = (0, _react.useMemo)(function () {
    if (listItems) {
      return listItems.map(function (item, index) {
        return [(0, _react2.jsx)(_description_list_title.EuiDescriptionListTitle, (0, _extends2.default)({
          key: "title-".concat(index)
        }, titleProps), item.title), (0, _react2.jsx)(_description_list_description.EuiDescriptionListDescription, (0, _extends2.default)({
          key: "description-".concat(index)
        }, descriptionProps), item.description)];
      });
    }
  }, [listItems, descriptionProps, titleProps]);
  return (0, _react2.jsx)(_description_list_context.EuiDescriptionListContext.Provider, {
    value: {
      type: type,
      compressed: compressed,
      textStyle: textStyle,
      align: align,
      rowGutterSize: rowGutterSize
    }
  }, (0, _react2.jsx)("dl", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    style: inlineStyles
  }, rest, {
    "data-type": _type
  }), listItems ? renderedListItems : children));
};