"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescriptionListDescription = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _description_list_context = require("./description_list_context");
var _description_list_description = require("./description_list_description.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Export required for correct inference by HOCs
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiDescriptionListDescription = exports.EuiDescriptionListDescription = function EuiDescriptionListDescription(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_description_list_context.EuiDescriptionListContext),
    type = _useContext.type,
    textStyle = _useContext.textStyle,
    compressed = _useContext.compressed,
    align = _useContext.align;
  var styles = (0, _services.useEuiMemoizedStyles)(_description_list_description.euiDescriptionListDescriptionStyles);
  var conditionalStyles = compressed && textStyle === 'reverse' ? [styles.fontStyles.compressed] : [styles.fontStyles[textStyle]];
  switch (type) {
    case 'inline':
      conditionalStyles = compressed ? [styles.inlineStyles.compressed] : [styles.inlineStyles.normal];
      break;
    case 'column':
      if (align === 'center') {
        conditionalStyles.push(styles.left);
      }
      break;
  }
  var cssStyles = [styles.euiDescriptionList__description, styles[type]].concat((0, _toConsumableArray2.default)(conditionalStyles));
  var classes = (0, _classnames.default)('euiDescriptionList__description', className);
  return (0, _react2.jsx)("dd", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), children);
};