"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _drag_drop_context = require("./drag_drop_context");
var _services = require("./services");
var _draggable = require("./draggable");
var _droppable = require("./droppable");
var _panel = require("../panel");
var _services2 = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var makeId = (0, _services2.htmlIdGenerator)();
var makeList = function makeList(number) {
  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  return Array.from({
    length: number
  }, function (v, k) {
    return k + start;
  }).map(function (el) {
    return {
      content: "Item ".concat(el),
      id: makeId()
    };
  });
};
var DragAndDrop = function DragAndDrop() {
  var _useState = (0, _react.useState)(makeList(3)),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    list = _useState2[0],
    setList = _useState2[1];
  var onDragEnd = function onDragEnd(_ref) {
    var source = _ref.source,
      destination = _ref.destination;
    if (source && destination) {
      var items = (0, _services.euiDragDropReorder)(list, source.index, destination.index);
      setList(items);
    }
  };
  return (0, _react2.jsx)(_drag_drop_context.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, (0, _react2.jsx)(_droppable.EuiDroppable, {
    droppableId: "DROPPABLE_AREA",
    spacing: "m",
    withPanel: true
  }, list.map(function (_ref2, idx) {
    var content = _ref2.content,
      id = _ref2.id;
    return (0, _react2.jsx)(_draggable.EuiDraggable, {
      spacing: "m",
      key: id,
      index: idx,
      draggableId: id,
      "data-test-subj": "cy-draggable-".concat(idx)
    }, function (provided, state) {
      return (0, _react2.jsx)(_panel.EuiPanel, {
        hasShadow: state.isDragging
      }, content, state.isDragging && ' ✨');
    });
  })));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(DragAndDrop, null));
});
describe('EuiDragDrop', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when an item is in draggable state', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when an item has been reordered and dropped', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.realPress('ArrowDown');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-2"]').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowUp');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-0"]').should('have.focus');
      cy.checkAxe();
    });
  });
});