"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.EuiEmptyPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _title = require("../title");
var _flex = require("../flex");
var _spacer = require("../spacer");
var _icon = require("../icon");
var _named_colors = require("../icon/named_colors");
var _text = require("../text");
var _panel = require("../panel/panel");
var _empty_prompt = require("./empty_prompt.styles");
var _react2 = require("@emotion/react");
var _excluded = ["icon", "iconType", "iconColor", "title", "titleSize", "paddingSize", "body", "actions", "className", "layout", "hasBorder", "color", "footer"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 's', 'm', 'l'];
var EuiEmptyPrompt = exports.EuiEmptyPrompt = function EuiEmptyPrompt(_ref) {
  var icon = _ref.icon,
    iconType = _ref.iconType,
    _iconColor = _ref.iconColor,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'm' : _ref$titleSize,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    body = _ref.body,
    actions = _ref.actions,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    hasBorder = _ref.hasBorder,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'transparent' : _ref$color,
    footer = _ref.footer,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiEmptyPrompt', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_empty_prompt.euiEmptyPromptStyles);
  var cssStyles = [styles.euiEmptyPrompt, styles[layout]];
  var mainStyles = [styles.main.euiEmptyPrompt__main, styles.main[layout], styles.main[paddingSize], layout === 'horizontal' && styles.main.horizontalPadding[paddingSize]];
  var contentStyles = [styles.content.euiEmptyPrompt__content, styles.content[layout]];

  // Default the iconColor to `subdued`,
  // otherwise try to match the iconColor with the panel color unless iconColor is specified
  var iconColor = _iconColor !== null && _iconColor !== void 0 ? _iconColor : (0, _named_colors.isNamedColor)(color) ? color : 'subdued';
  var iconNode = (0, _react.useMemo)(function () {
    if (!iconType && !icon) return null;
    var iconStyles = [styles.icon.euiEmptyPrompt__icon, styles.icon[layout]];
    return (0, _react2.jsx)("div", {
      className: "euiEmptyPrompt__icon",
      css: iconStyles
    }, iconType ? (0, _react2.jsx)(_icon.EuiIcon, {
      type: iconType,
      size: "xxl",
      color: iconColor
    }) : icon);
  }, [icon, iconType, iconColor, layout, styles.icon]);
  var actionsNode = (0, _react.useMemo)(function () {
    if (!actions) return null;
    if (Array.isArray(actions)) {
      var actionStyles = [styles.actions.euiEmptyPrompt__actions, styles.actions[layout]];
      return (0, _react2.jsx)(_flex.EuiFlexGroup, {
        className: "euiEmptyPrompt__actions",
        css: actionStyles,
        gutterSize: "m",
        alignItems: "center",
        justifyContent: "center",
        direction: layout === 'vertical' ? 'column' : 'row'
      }, actions.map(function (action, index) {
        return (0, _react2.jsx)(_flex.EuiFlexItem, {
          key: index,
          grow: false
        }, action);
      }));
    } else {
      return actions;
    }
  }, [actions, layout, styles.actions]);
  var footerNode = (0, _react.useMemo)(function () {
    if (!footer) return null;
    var footerStyles = [styles.footer.euiEmptyPrompt__footer, styles.footer[paddingSize], styles.footer[color], color === 'transparent' && !hasBorder && styles.footer.roundedBorders];
    return (0, _react2.jsx)("div", {
      className: "euiEmptyPrompt__footer",
      css: footerStyles
    }, footer);
  }, [footer, paddingSize, color, hasBorder, styles.footer]);
  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    color: color,
    paddingSize: "none",
    grow: false,
    hasBorder: hasBorder
  }, rest), (0, _react2.jsx)("div", {
    className: "euiEmptyPrompt__main",
    css: mainStyles
  }, iconNode, (0, _react2.jsx)("div", {
    className: "euiEmptyPrompt__content",
    css: contentStyles
  }, title && (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize
  }, title), title && body && (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), body && (0, _react2.jsx)(_text.EuiText, {
    color: "subdued"
  }, body), actionsNode && (body || title) && (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "l"
  }), actionsNode)), footerNode);
};