"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExpression = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _services = require("../../services");
var _expression = require("./expression.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "description", "descriptionProps", "value", "valueProps", "color", "uppercase", "isActive", "display", "descriptionWidth", "onClick", "isInvalid", "textWrap"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var COLORS = exports.COLORS = ['subdued', 'primary', 'success', 'accent', 'warning', 'danger'];
var EuiExpression = exports.EuiExpression = function EuiExpression(_ref) {
  var className = _ref.className,
    description = _ref.description,
    descriptionProps = _ref.descriptionProps,
    value = _ref.value,
    valueProps = _ref.valueProps,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$uppercase = _ref.uppercase,
    uppercase = _ref$uppercase === void 0 ? true : _ref$uppercase,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? false : _ref$isActive,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'inline' : _ref$display,
    _ref$descriptionWidth = _ref.descriptionWidth,
    descriptionWidth = _ref$descriptionWidth === void 0 ? '20%' : _ref$descriptionWidth,
    onClick = _ref.onClick,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'break-word' : _ref$textWrap,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var calculatedColor = isInvalid ? 'danger' : color;
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _expression.euiExpressionStyles)(theme);
  var cssStyles = [styles.euiExpression, onClick && styles.isClickable, styles[color], isActive && styles.isActive.base, isActive && styles.isActive[color], display === 'columns' && styles.columns, textWrap === 'truncate' && styles.truncate];
  var descriptionStyles = (0, _expression.euiExpressionDescriptionStyles)(theme);
  var cssDescriptionStyles = [descriptionStyles.euiExpression__description, isInvalid ? descriptionStyles.danger : descriptionStyles[color], uppercase && descriptionStyles.isUppercase, textWrap === 'truncate' && descriptionStyles.truncate, display === 'columns' && descriptionStyles.columns];
  var valueStyles = (0, _expression.euiExpressionValueStyles)(theme);
  var cssValueStyles = [valueStyles.euiExpression__value, textWrap === 'truncate' && valueStyles.truncate, display === 'columns' && valueStyles.columns];
  var iconStyles = (0, _expression.euiExpressionIconStyles)(theme);
  var cssIconStyles = [iconStyles.euiExpression__icon, display === 'columns' && iconStyles.columns];
  var classes = (0, _classnames.default)('euiExpression', className);
  var Component = onClick ? 'button' : 'span';
  var customWidth = display === 'columns' && descriptionWidth ? {
    flexBasis: descriptionWidth
  } : undefined;
  var invalidIcon = isInvalid ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiExpression__icon",
    type: "warning",
    css: cssIconStyles,
    color: calculatedColor
  }) : undefined;
  return (0, _react2.jsx)(Component, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    onClick: onClick
  }, rest), (0, _react2.jsx)("span", (0, _extends2.default)({}, descriptionProps, {
    className: (0, _classnames.default)('euiExpression__description', descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.className),
    css: [].concat(cssDescriptionStyles, [descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.css]),
    style: _objectSpread(_objectSpread({}, customWidth), descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.style)
  }), description), ' ', value && (0, _react2.jsx)("span", (0, _extends2.default)({}, valueProps, {
    className: (0, _classnames.default)('euiExpression__value', valueProps === null || valueProps === void 0 ? void 0 : valueProps.className),
    css: [].concat(cssValueStyles, [valueProps === null || valueProps === void 0 ? void 0 : valueProps.css])
  }), value), invalidIcon);
};