"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _filter_group = require("./filter_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "fullWidth", "compressed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFilterGroup = exports.EuiFilterGroup = function EuiFilterGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    compressed = _ref.compressed,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _filter_group.euiFilterGroupStyles)(euiTheme);
  var cssStyles = [styles.euiFilterGroup, fullWidth && styles.fullWidth, compressed ? styles.compressed : styles.uncompressed];
  var classes = (0, _classnames.default)('euiFilterGroup', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), children);
};