"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterSelectItemClass = exports.EuiFilterSelectItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex = require("../flex");
var _tool_tip = require("../tool_tip");
var _icon = require("../icon");
var _filter_select_item = require("./filter_select_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["theme", "children", "className", "disabled", "checked", "isFocused", "showIcons", "toolTipContent", "toolTipProps", "style"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var resolveIconAndColor = function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }
  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
};

/**
 * TODO: This component should removed in favor of EuiSelectable usage
 * once EuiComboBox has been converted to dogfood EuiSelectable.
 *
 * @deprecated - Use EuiSelectable instead
 */
var EuiFilterSelectItemClass = exports.EuiFilterSelectItemClass = /*#__PURE__*/function (_Component) {
  function EuiFilterSelectItemClass() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiFilterSelectItemClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilterSelectItemClass, [].concat(args));
    (0, _defineProperty2.default)(_this, "buttonRef", null);
    (0, _defineProperty2.default)(_this, "tooltipRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "state", {
      hasFocus: false
    });
    (0, _defineProperty2.default)(_this, "focus", function () {
      if (_this.buttonRef) {
        _this.buttonRef.focus();
      }
    });
    (0, _defineProperty2.default)(_this, "toggleToolTip", function (isFocused) {
      if (isFocused) {
        var _this$tooltipRef;
        (_this$tooltipRef = _this.tooltipRef) === null || _this$tooltipRef === void 0 || (_this$tooltipRef = _this$tooltipRef.current) === null || _this$tooltipRef === void 0 || _this$tooltipRef.showToolTip();
      } else {
        var _this$tooltipRef2;
        (_this$tooltipRef2 = _this.tooltipRef) === null || _this$tooltipRef2 === void 0 || (_this$tooltipRef2 = _this$tooltipRef2.current) === null || _this$tooltipRef2 === void 0 || _this$tooltipRef2.hideToolTip();
      }
    });
    (0, _defineProperty2.default)(_this, "hasFocus", function () {
      return _this.state.hasFocus;
    });
    return _this;
  }
  (0, _inherits2.default)(EuiFilterSelectItemClass, _Component);
  return (0, _createClass2.default)(EuiFilterSelectItemClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        theme = _this$props.theme,
        children = _this$props.children,
        className = _this$props.className,
        disabled = _this$props.disabled,
        checked = _this$props.checked,
        isFocused = _this$props.isFocused,
        showIcons = _this$props.showIcons,
        toolTipContent = _this$props.toolTipContent,
        toolTipProps = _this$props.toolTipProps,
        style = _this$props.style,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var styles = (0, _filter_select_item.euiFilterSelectItemStyles)(theme);
      var cssStyles = [styles.euiFilterSelectItem, isFocused && styles.isFocused];
      var classes = (0, _classnames.default)('euiFilterSelectItem', className);
      var hasToolTip =
      // we're using isValidElement here as EuiToolTipAnchor uses
      // cloneElement to enhance the element with required attributes
      /*#__PURE__*/_react.default.isValidElement(children) && !disabled && toolTipContent;
      var anchorProps = undefined;
      if (hasToolTip) {
        var _toolTipProps$anchorP, _toolTipProps$anchorP2;
        var anchorStyles = toolTipProps !== null && toolTipProps !== void 0 && (_toolTipProps$anchorP = toolTipProps.anchorProps) !== null && _toolTipProps$anchorP !== void 0 && _toolTipProps$anchorP.style ? _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.style), style) : style;
        anchorProps = toolTipProps !== null && toolTipProps !== void 0 && toolTipProps.anchorProps ? _objectSpread(_objectSpread({}, toolTipProps.anchorProps), {}, {
          style: anchorStyles
        }) : {
          style: style
        };
        this.toggleToolTip(isFocused !== null && isFocused !== void 0 ? isFocused : false);
      }
      var iconNode;
      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
          icon = _resolveIconAndColor.icon,
          color = _resolveIconAndColor.color;
        iconNode = (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_icon.EuiIcon, {
          color: color,
          type: icon
        }));
      }
      var optionItem = (0, _react2.jsx)("button", (0, _extends2.default)({
        ref: function ref(_ref) {
          return _this2.buttonRef = _ref;
        },
        role: "option",
        type: "button",
        "aria-selected": isFocused,
        className: classes,
        css: cssStyles,
        disabled: disabled,
        "aria-disabled": disabled,
        style: !hasToolTip ? style : undefined
      }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        component: "span",
        responsive: false
      }, iconNode, (0, _react2.jsx)(_flex.EuiFlexItem, {
        className: "euiFilterSelectItem__content eui-textTruncate",
        component: "span"
      }, children)));
      return hasToolTip ? (0, _react2.jsx)(_tool_tip.EuiToolTip, (0, _extends2.default)({
        ref: this.tooltipRef,
        display: "block",
        content: toolTipContent,
        position: "left"
      }, toolTipProps, {
        anchorProps: anchorProps
      }), optionItem) : optionItem;
    }
  }]);
}(_react.Component);
/**
 * @deprecated - Use EuiSelectable instead
 */
(0, _defineProperty2.default)(EuiFilterSelectItemClass, "defaultProps", {
  showIcons: true
});
var EuiFilterSelectItem = exports.EuiFilterSelectItem = (0, _services.withEuiTheme)(EuiFilterSelectItemClass);