"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiFlexGrid = exports.DIRECTIONS = exports.ALIGN_ITEMS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex_grid = require("./flex_grid.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "style", "gutterSize", "direction", "alignItems", "responsive", "columns", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var DIRECTIONS = exports.DIRECTIONS = ['row', 'column'];
var ALIGN_ITEMS = exports.ALIGN_ITEMS = ['stretch', 'start', 'end', 'center', 'baseline'];
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 's', 'm', 'l', 'xl'];
var EuiFlexGrid = exports.EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$columns = _ref.columns,
    columns = _ref$columns === void 0 ? 1 : _ref$columns,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiFlexGrid', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_flex_grid.euiFlexGridStyles);
  var cssStyles = [styles.euiFlexGrid, styles.gutterSizes[gutterSize], styles.direction[direction], styles.alignItems[alignItems], styles.columnCount[columns], responsive && styles.responsive];
  var columnDirectionStyles = (0, _react.useMemo)(function () {
    if (direction === 'column') {
      var rowsToRender = Math.ceil(_react.default.Children.count(children) / columns);
      return {
        gridTemplateRows: "repeat(".concat(rowsToRender, ", 1fr)")
      };
    }
  }, [direction, columns, children]);
  return (0, _react2.jsx)(Component, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    style: columnDirectionStyles ? _objectSpread(_objectSpread({}, style), columnDirectionStyles) : style
  }, rest), children);
};