"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlexItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _flex_item = require("./flex_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "grow", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var VALID_GROW_VALUES = [null, undefined, true, false, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var EuiFlexItemInternal = function EuiFlexItemInternal(_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  (0, _react.useEffect)(function () {
    if (VALID_GROW_VALUES.indexOf(grow) === -1) {
      throw new Error("Prop `grow` passed to `EuiFlexItem` must be a boolean or an integer between 0 and 10, received `".concat(grow, "`"));
    }
  }, [grow]);
  var cssStyles = [_flex_item.euiFlexItemStyles.euiFlexItem, !grow ? _flex_item.euiFlexItemStyles.growZero : _flex_item.euiFlexItemStyles.grow, grow && (typeof grow === 'number' ? _flex_item.euiFlexItemStyles.growSizes[grow] : _flex_item.euiFlexItemStyles.growSizes['1'])];
  var classes = (0, _classnames.default)('euiFlexItem', className);

  // Cast `component` to FunctionComponent to simplify its type.
  // Note that FunctionComponent type is used here for purely typing
  // convenience since we specify the return type above, and function
  // components don't support `ref`s, but that doesn't matter in this case.
  var Component = component;
  return (0, _react2.jsx)(Component, (0, _extends2.default)({}, rest, {
    ref: ref,
    css: cssStyles,
    className: classes
  }), children);
};

// Cast forwardRef return type to work with the generic TComponent type
// and not fallback to implicit any typing
var EuiFlexItem = exports.EuiFlexItem = /*#__PURE__*/(0, _react.forwardRef)(EuiFlexItemInternal);
EuiFlexItem.displayName = 'EuiFlexItem';