"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _badge = require("../badge");
var _button = require("../button");
var _form = require("../form");
var _focus_trap = require("./focus_trap");
var _spacer = require("../spacer");
var _panel = require("../panel");
var _text = require("../text");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var CheckboxGroup = function CheckboxGroup() {
  var checkboxGroupItemId__1 = (0, _services.useGeneratedHtmlId)({
    prefix: 'checkboxGroupItem',
    suffix: 'first'
  });
  var checkboxGroupItemId__2 = (0, _services.useGeneratedHtmlId)({
    prefix: 'checkboxGroupItem',
    suffix: 'second'
  });
  var checkboxes = [{
    id: checkboxGroupItemId__1,
    label: 'Option one is checked by default'
  }, {
    id: checkboxGroupItemId__2,
    label: 'Option two'
  }];
  var _useState = (0, _react.useState)((0, _defineProperty2.default)({}, checkboxGroupItemId__1, true)),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    checkboxIdToSelectedMap = _useState2[0];
  return (0, _react2.jsx)(_form.EuiCheckboxGroup, {
    options: checkboxes,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange() {}
  });
};
var FocusTrap = function FocusTrap() {
  var _useState4 = (0, _react.useState)(true),
    _useState5 = (0, _slicedToArray2.default)(_useState4, 2),
    isDisabled = _useState5[0],
    changeDisabled = _useState5[1];
  var toggleDisabled = function toggleDisabled() {
    return changeDisabled(!isDisabled);
  };
  return (0, _react2.jsx)("div", {
    "data-test-subj": "cy-trap-container"
  }, (0, _react2.jsx)(_badge.EuiBadge, {
    "data-test-subj": "cy-trap-message"
  }, "Trap is ", isDisabled ? 'disabled' : 'enabled'), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    disabled: isDisabled
  }, (0, _react2.jsx)(_panel.EuiPanel, null, (0, _react2.jsx)(_form.EuiFieldText, {
    "data-test-subj": "cy-input-one",
    placeholder: "Placeholder text first input",
    value: "",
    onChange: function onChange() {},
    "aria-label": "First focusable input"
  }), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(CheckboxGroup, null), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_button.EuiButton, {
    onClick: toggleDisabled,
    "data-test-subj": "cy-focus-trap-button"
  }, "".concat(!isDisabled ? 'Disable' : 'Enable', " Focus Trap")))), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "l"
  }), (0, _react2.jsx)(_text.EuiText, null, "The button below is not focusable by keyboard as long as the focus trap is enabled."), (0, _react2.jsx)(_button.EuiButton, {
    onClick: function onClick() {},
    "data-test-subj": "cy-external-button"
  }, "External Focusable Element"));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(FocusTrap, null));
});
describe('EuiFocusTrap', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the focus trap is enabled', function () {
      cy.get('button[data-test-subj="cy-focus-trap-button"]').realClick();
      cy.get('span[ data-test-subj="cy-trap-message"]').should('have.text', 'Trap is enabled');
      cy.checkAxe();
    });
  });
  describe('Accessibility checks for keyboard navigation', function () {
    it('allows the button outside the FocusTrap to receive focus', function () {
      cy.get('button[data-test-subj="cy-external-button"]').focus();
      cy.checkAxe();
    });
    it('prevents the button outside the FocusTrap from receiving focus', function () {
      cy.get('input[data-test-subj="cy-input-one"]').focus();
      cy.repeatRealPress('Tab', 3);
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.get('input[data-test-subj="cy-input-one"]').should('have.focus');
      cy.checkAxe();
    });
  });
});