"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFocusTrap = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactFocusOn = require("react-focus-on");
var _reactRemoveScrollBar = require("react-remove-scroll-bar");
var _services = require("../../services");
var _component_defaults = require("../provider/component_defaults");
var _react2 = require("@emotion/react");
var _excluded = ["children", "clickOutsideDisables", "disabled", "returnFocus", "noIsolation", "scrollLock", "gapMode"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFocusTrap = exports.EuiFocusTrap = function EuiFocusTrap(props) {
  var propsWithDefaults = (0, _component_defaults.usePropsWithComponentDefaults)('EuiFocusTrap', props);
  return (0, _react2.jsx)(EuiFocusTrapClass, propsWithDefaults);
};
var EuiFocusTrapClass = /*#__PURE__*/function (_Component) {
  function EuiFocusTrapClass() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiFocusTrapClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFocusTrapClass, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      hasBeenDisabledByClick: false
    });
    (0, _defineProperty2.default)(_this, "lastInterceptedEvent", null);
    (0, _defineProperty2.default)(_this, "preventFocusExit", false);
    // Programmatically sets focus on a nested DOM node; optional
    (0, _defineProperty2.default)(_this, "setInitialFocus", function (initialFocus) {
      if (!initialFocus) return;
      var node = (0, _services.findElementBySelectorOrRef)(initialFocus);
      if (!node) return;
      // `data-autofocus` is part of the 'react-focus-on' API
      node.setAttribute('data-autofocus', 'true');
    });
    (0, _defineProperty2.default)(_this, "onMouseupOutside", function (e) {
      _this.removeMouseupListener();
      // Timeout gives precedence to the consumer to initiate close if it has toggle behavior.
      // Otherwise this event may occur first and the consumer toggle will reopen the flyout.
      setTimeout(function () {
        var _this$props$onClickOu, _this$props;
        return (_this$props$onClickOu = (_this$props = _this.props).onClickOutside) === null || _this$props$onClickOu === void 0 ? void 0 : _this$props$onClickOu.call(_this$props, e);
      });
    });
    (0, _defineProperty2.default)(_this, "addMouseupListener", function () {
      document.addEventListener('mouseup', _this.onMouseupOutside);
      document.addEventListener('touchend', _this.onMouseupOutside);
    });
    (0, _defineProperty2.default)(_this, "removeMouseupListener", function () {
      document.removeEventListener('mouseup', _this.onMouseupOutside);
      document.removeEventListener('touchend', _this.onMouseupOutside);
    });
    (0, _defineProperty2.default)(_this, "handleOutsideClick", function (event) {
      var _this$props2 = _this.props,
        onClickOutside = _this$props2.onClickOutside,
        clickOutsideDisables = _this$props2.clickOutsideDisables,
        closeOnMouseup = _this$props2.closeOnMouseup;
      if (clickOutsideDisables) {
        _this.setState({
          hasBeenDisabledByClick: true
        });
      }
      if (onClickOutside) {
        closeOnMouseup ? _this.addMouseupListener() : onClickOutside(event);
      }
    });
    return _this;
  }
  (0, _inherits2.default)(EuiFocusTrapClass, _Component);
  return (0, _createClass2.default)(EuiFocusTrapClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeMouseupListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        children = _this$props3.children,
        clickOutsideDisables = _this$props3.clickOutsideDisables,
        disabled = _this$props3.disabled,
        returnFocus = _this$props3.returnFocus,
        noIsolation = _this$props3.noIsolation,
        scrollLock = _this$props3.scrollLock,
        gapMode = _this$props3.gapMode,
        rest = (0, _objectWithoutProperties2.default)(_this$props3, _excluded);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;
      var focusOnProps = _objectSpread(_objectSpread({
        returnFocus: returnFocus,
        noIsolation: noIsolation,
        enabled: !isDisabled
      }, rest), {}, {
        onClickOutside: this.handleOutsideClick,
        /**
         * `scrollLock` should always be unset on FocusOn, as it can prevent scrolling on
         * portals (i.e. popovers, comboboxes, dropdown menus, etc.) within modals & flyouts
         * @see https://github.com/theKashey/react-focus-on/issues/49
         */
        scrollLock: false
      });
      return (0, _react2.jsx)(_reactFocusOn.FocusOn, focusOnProps, children, !isDisabled && scrollLock && (0, _react2.jsx)(_reactRemoveScrollBar.RemoveScrollBar, {
        gapMode: gapMode
      }));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiFocusTrapClass, "defaultProps", {
  clickOutsideDisables: false,
  disabled: false,
  returnFocus: true,
  noIsolation: true,
  scrollLock: false,
  crossFrame: false,
  gapMode: 'padding' // EUI defaults to padding because Kibana's body/layout CSS ignores `margin`
});