"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilePickerClass = exports.EuiFilePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button = require("../../button");
var _progress = require("../../progress");
var _icon = require("../../icon");
var _i18n = require("../../i18n");
var _loading = require("../../loading");
var _eui_form_context = require("../eui_form_context");
var _validatable_control = require("../validatable_control");
var _form_control_layout_clear_button = require("../form_control_layout/form_control_layout_clear_button");
var _file_picker = require("./file_picker.styles");
var _react2 = require("@emotion/react");
var _excluded = ["stylesMemoizer", "id", "name", "initialPromptText", "className", "disabled", "compressed", "onChange", "isInvalid", "fullWidth", "isLoading", "display"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFilePickerClass = exports.EuiFilePickerClass = /*#__PURE__*/function (_Component) {
  function EuiFilePickerClass() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiFilePickerClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilePickerClass, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      promptText: null,
      isHoveringDrop: false
    });
    (0, _defineProperty2.default)(_this, "fileInput", null);
    (0, _defineProperty2.default)(_this, "generatedId", (0, _services.htmlIdGenerator)()());
    (0, _defineProperty2.default)(_this, "handleChange", function () {
      if (!_this.fileInput) return;
      if (_this.fileInput.files && _this.fileInput.files.length > 1) {
        _this.setState({
          promptText: (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiFilePicker.filesSelected",
            default: "{fileCount} files selected",
            values: {
              fileCount: _this.fileInput.files.length
            }
          })
        });
      } else if (_this.fileInput.files && _this.fileInput.files.length === 0) {
        _this.setState({
          promptText: null
        });
      } else {
        _this.setState({
          promptText: _this.fileInput.value.split('\\').pop()
        });
      }
      var onChange = _this.props.onChange;
      if (onChange) {
        onChange(_this.fileInput.files);
      }
    });
    (0, _defineProperty2.default)(_this, "removeFiles", function (e) {
      if (e) {
        e.stopPropagation();
        e.preventDefault();
      }
      if (!_this.fileInput) return;
      _this.fileInput.value = '';
      _this.handleChange();
    });
    (0, _defineProperty2.default)(_this, "showDrop", function () {
      if (!_this.props.disabled) {
        _this.setState({
          isHoveringDrop: true
        });
      }
    });
    (0, _defineProperty2.default)(_this, "hideDrop", function () {
      _this.setState({
        isHoveringDrop: false
      });
    });
    return _this;
  }
  (0, _inherits2.default)(EuiFilePickerClass, _Component);
  return (0, _createClass2.default)(EuiFilePickerClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiFilePicker.removeSelectedAriaLabel",
        default: "Remove selected files"
      }, function (removeSelectedAriaLabel) {
        var _this2$props = _this2.props,
          stylesMemoizer = _this2$props.stylesMemoizer,
          id = _this2$props.id,
          name = _this2$props.name,
          initialPromptText = _this2$props.initialPromptText,
          className = _this2$props.className,
          disabled = _this2$props.disabled,
          compressed = _this2$props.compressed,
          onChange = _this2$props.onChange,
          isInvalid = _this2$props.isInvalid,
          _this2$props$fullWidt = _this2$props.fullWidth,
          fullWidth = _this2$props$fullWidt === void 0 ? defaultFullWidth : _this2$props$fullWidt,
          isLoading = _this2$props.isLoading,
          display = _this2$props.display,
          rest = (0, _objectWithoutProperties2.default)(_this2$props, _excluded);
        var promptId = "".concat(id || _this2.generatedId, "-filePicker__prompt");
        var isOverridingInitialPrompt = _this2.state.promptText != null;
        var normalFormControl = display === 'default';
        var classes = (0, _classnames.default)('euiFilePicker', {
          'euiFilePicker-isDroppingFile': _this2.state.isHoveringDrop,
          'euiFilePicker-isInvalid': isInvalid,
          'euiFilePicker-isLoading': isLoading,
          'euiFilePicker-hasFiles': isOverridingInitialPrompt
        }, className);
        var styles = stylesMemoizer(_file_picker.euiFilePickerStyles);
        var cssStyles = [styles.euiFilePicker, fullWidth ? styles.fullWidth : styles.formWidth, _this2.state.isHoveringDrop && styles.isDroppingFile, isInvalid && !disabled && styles.invalid, isOverridingInitialPrompt && !disabled && styles.hasFiles, isLoading && styles.loading];
        var inputStyles = [styles.input.euiFilePicker__input, !normalFormControl && !disabled && styles.input.largeInteractive];
        var promptStyles = [styles.euiFilePicker__prompt, disabled && styles.disabled].concat((0, _toConsumableArray2.default)(normalFormControl ? [compressed ? styles.compressed : styles.uncompressed] : [styles.large.large, compressed ? styles.large.compressed : styles.large.uncompressed]));
        var iconStyles = [styles.icon.euiFilePicker__icon].concat((0, _toConsumableArray2.default)(normalFormControl ? [styles.icon.normal, compressed ? styles.icon.compresssed : styles.icon.uncompressed] : [styles.icon.large]));
        var rightIconStyles = normalFormControl ? [styles.rightIcon.euiFilePicker__rightIcon, compressed ? styles.rightIcon.compressed : styles.rightIcon.uncompressed] : undefined;
        var clearButton;
        if (isLoading && normalFormControl) {
          // Override clear button with loading spinner if it is in loading state
          clearButton = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
            css: rightIconStyles,
            className: "euiFilePicker__loadingSpinner",
            size: compressed ? 's' : 'm'
          });
        } else if (isOverridingInitialPrompt && !disabled) {
          if (normalFormControl) {
            clearButton = (0, _react2.jsx)(_form_control_layout_clear_button.EuiFormControlLayoutClearButton, {
              "aria-label": removeSelectedAriaLabel,
              css: [styles.euiFilePicker__clearButton, rightIconStyles, ";label:clearButton;"],
              className: "euiFilePicker__clearButton",
              onClick: _this2.removeFiles,
              size: compressed ? 's' : 'm'
            });
          } else {
            clearButton = (0, _react2.jsx)(_button.EuiButtonEmpty, {
              "aria-label": removeSelectedAriaLabel,
              css: styles.euiFilePicker__clearButton,
              className: "euiFilePicker__clearButton",
              size: "xs",
              onClick: _this2.removeFiles
            }, (0, _react2.jsx)(_i18n.EuiI18n, {
              token: "euiFilePicker.removeSelected",
              default: "Remove"
            }));
          }
        } else {
          clearButton = null;
        }
        var loader = !normalFormControl && isLoading && (0, _react2.jsx)(_progress.EuiProgress, {
          size: "xs",
          color: "accent",
          position: "absolute"
        });
        return (0, _react2.jsx)("div", {
          css: cssStyles,
          className: classes
        }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
          isInvalid: isInvalid
        }, (0, _react2.jsx)("input", (0, _extends2.default)({
          type: "file",
          id: id,
          name: name,
          css: inputStyles,
          className: "euiFilePicker__input",
          onChange: _this2.handleChange,
          ref: function ref(input) {
            _this2.fileInput = input;
          },
          onDragOver: _this2.showDrop,
          onDragLeave: _this2.hideDrop,
          onDrop: _this2.hideDrop,
          disabled: disabled,
          "aria-describedby": promptId
        }, rest))), (0, _react2.jsx)("div", {
          css: promptStyles,
          className: "euiFilePicker__prompt",
          id: promptId
        }, (0, _react2.jsx)(_icon.EuiIcon, {
          css: iconStyles,
          className: "euiFilePicker__icon",
          color: isInvalid ? 'danger' : disabled ? 'subdued' : 'primary',
          type: isInvalid ? 'alert' : 'importAction',
          size: normalFormControl ? 'm' : 'l',
          "aria-hidden": "true"
        }), (0, _react2.jsx)("span", {
          className: "euiFilePicker__promptText"
        }, _this2.state.promptText || initialPromptText), clearButton, loader));
      });
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiFilePickerClass, "contextType", _eui_form_context.FormContext);
(0, _defineProperty2.default)(EuiFilePickerClass, "defaultProps", {
  initialPromptText: (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFilePicker.promptText",
    default: "Select or drag and drop a file"
  }),
  compressed: false,
  display: 'large'
});
var EuiFilePicker = exports.EuiFilePicker = (0, _services.withEuiStylesMemoizer)(EuiFilePickerClass);