"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilePickerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "6h1iuq-euiFilePicker__clearButton",
  styles: "pointer-events:auto;position:relative;label:euiFilePicker__clearButton;"
} : {
  name: "6h1iuq-euiFilePicker__clearButton",
  styles: "pointer-events:auto;position:relative;label:euiFilePicker__clearButton;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "d8me89-euiFilePicker__rightIcon",
  styles: "position:absolute;label:euiFilePicker__rightIcon;"
} : {
  name: "d8me89-euiFilePicker__rightIcon",
  styles: "position:absolute;label:euiFilePicker__rightIcon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "19x04ih-largeInteractive",
  styles: "&:hover,&:focus,.euiFilePicker-isDroppingFile &{&+.euiFilePicker__prompt{.euiFilePicker__promptText{text-decoration:underline;}.euiFilePicker__icon{transform:scale(1.1);}}};label:largeInteractive;"
} : {
  name: "19x04ih-largeInteractive",
  styles: "&:hover,&:focus,.euiFilePicker-isDroppingFile &{&+.euiFilePicker__prompt{.euiFilePicker__promptText{text-decoration:underline;}.euiFilePicker__icon{transform:scale(1.1);}}};label:largeInteractive;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1j9s7hu-euiFilePicker__input",
  styles: "position:absolute;inset:0;opacity:0;&:hover{cursor:pointer;}&:hover:disabled{cursor:not-allowed;}&:disabled{opacity:0;};label:euiFilePicker__input;"
} : {
  name: "1j9s7hu-euiFilePicker__input",
  styles: "position:absolute;inset:0;opacity:0;&:hover{cursor:pointer;}&:hover:disabled{cursor:not-allowed;}&:disabled{opacity:0;};label:euiFilePicker__input;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilePickerStyles = exports.euiFilePickerStyles = function euiFilePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  var formVariables = (0, _form.euiFormVariables)(euiThemeContext);
  var _euiFontSize = (0, _global_styling.euiFontSize)(euiThemeContext, 's'),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  return {
    euiFilePicker: /*#__PURE__*/(0, _react.css)("--euiFormControlLeftIconsCount:1;position:relative;&:has(input:focus){--euiFormControlStateColor:", euiTheme.colors.primary, ";};label:euiFilePicker;"),
    isDroppingFile: /*#__PURE__*/(0, _react.css)("--euiFormControlStateColor:", euiTheme.colors.primary, ";;label:isDroppingFile;"),
    invalid: /*#__PURE__*/(0, _react.css)("--euiFormControlStateColor:", euiTheme.colors.danger, ";;label:invalid;"),
    hasFiles: /*#__PURE__*/(0, _react.css)("--euiFormControlRightIconsCount:1;font-weight:", euiTheme.font.weight.bold, ";;label:hasFiles;"),
    loading: /*#__PURE__*/(0, _react.css)("--euiFormControlRightIconsCount:1;border-radius:", formVariables.controlCompressedBorderRadius, ";overflow:hidden;;label:loading;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    // The input is an invisible dropzone / button
    input: {
      euiFilePicker__input: _ref4,
      largeInteractive: _ref3
    },
    euiFilePicker__prompt: /*#__PURE__*/(0, _react.css)("pointer-events:none;font-size:", fontSize, ";line-height:1;", (0, _global_styling.euiTextTruncate)(), " color:", euiTheme.colors.text, ";border:", euiTheme.border.width.thick, " dashed var(--euiFormControlStateColor, ", euiTheme.colors.lightShade, ");", _global_styling.euiCanAnimate, "{transition:border-color ", euiTheme.animation.fast, " ease-in,background-color ", euiTheme.animation.fast, " ease-in;};label:euiFilePicker__prompt;"),
    disabled: /*#__PURE__*/(0, _react.css)(formStyles.disabled, ";label:disabled;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, ";label:compressed;"),
    // Completely different rendering style from the normal form controls
    large: {
      large: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.l, ";display:flex;flex-direction:column;align-items:center;justify-content:center;.euiFilePicker__promptText{", (0, _global_styling.euiTextTruncate)(), " line-height:", lineHeight, ";};label:large;"),
      // Static heights so that surrounding contents don't shift around
      uncompressed: "\n        ".concat((0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 8;
      })), "\n        border-radius: ").concat(formVariables.controlBorderRadius, ";\n      "),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 6.5;
      })), " border-radius:", formVariables.controlCompressedBorderRadius, ";;label:compressed;")
    },
    icon: {
      euiFilePicker__icon: /*#__PURE__*/(0, _react.css)(";label:euiFilePicker__icon;"),
      normal: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('height', '100%'), ";;label:normal;"),
      uncompressed: "\n        ".concat((0, _global_styling.logicalCSS)('left', euiTheme.size.m), "\n      "),
      compresssed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('width', euiTheme.size.m), ";;label:compresssed;"),
      large: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), " ", _global_styling.euiCanAnimate, "{transition:transform ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";};label:large;")
    },
    rightIcon: {
      euiFilePicker__rightIcon: _ref2,
      uncompressed: "\n        ".concat((0, _global_styling.logicalCSS)('top', euiTheme.size.m), "\n        ").concat((0, _global_styling.logicalCSS)('right', euiTheme.size.m), "\n      "),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('top', '50%'), " ", (0, _global_styling.logicalCSS)('margin-top', (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
        return x / -2;
      })), ";;label:compressed;")
    },
    euiFilePicker__clearButton: _ref
  };
};