"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRightSideIcon = exports.getIconAffordanceStyles = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _form_control_layout_icons = require("./form_control_layout_icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var isRightSideIcon = exports.isRightSideIcon = function isRightSideIcon(icon) {
  return !!icon && (0, _form_control_layout_icons.isIconShape)(icon) && icon.side === 'right';
};
var getIconAffordanceStyles = exports.getIconAffordanceStyles = function getIconAffordanceStyles(_ref) {
  var icon = _ref.icon,
    clear = _ref.clear,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    isDropdown = _ref.isDropdown;
  var cssVariables = {
    '--euiFormControlLeftIconsCount': 0,
    '--euiFormControlRightIconsCount': 0
  };
  if (icon) {
    if (isRightSideIcon(icon)) {
      cssVariables['--euiFormControlRightIconsCount']++;
    } else {
      cssVariables['--euiFormControlLeftIconsCount']++;
    }
  }
  if (clear) cssVariables['--euiFormControlRightIconsCount']++;
  if (isLoading) cssVariables['--euiFormControlRightIconsCount']++;
  if (isInvalid) cssVariables['--euiFormControlRightIconsCount']++;
  if (isDropdown) cssVariables['--euiFormControlRightIconsCount']++;
  var filtered = Object.entries(cssVariables).filter(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      count = _ref3[1];
    return count > 0;
  });
  return filtered.length ? Object.fromEntries(filtered) : undefined;
};