"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _form_label = require("../form_label");
var _eui_form_context = require("../eui_form_context");
var _num_icons = require("./_num_icons");
var _form_control_layout_icons = require("./form_control_layout_icons");
var _form_control_layout = require("./form_control_layout.styles");
var _react2 = require("@emotion/react");
var _excluded = ["inputId", "className", "children", "icon", "iconsPosition", "clear", "isDropdown", "isLoading", "isInvalid", "isDisabled", "readOnly", "compressed", "prepend", "append", "isDelimited", "wrapperProps", "fullWidth"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiFormControlLayout = exports.EuiFormControlLayout = function EuiFormControlLayout(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var inputId = props.inputId,
    className = props.className,
    children = props.children,
    icon = props.icon,
    _props$iconsPosition = props.iconsPosition,
    iconsPosition = _props$iconsPosition === void 0 ? 'absolute' : _props$iconsPosition,
    clear = props.clear,
    isDropdown = props.isDropdown,
    isLoading = props.isLoading,
    isInvalid = props.isInvalid,
    isDisabled = props.isDisabled,
    readOnly = props.readOnly,
    compressed = props.compressed,
    prepend = props.prepend,
    append = props.append,
    isDelimited = props.isDelimited,
    wrapperProps = props.wrapperProps,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var isGroup = !!(prepend || append || isDelimited);
  var classes = (0, _classnames.default)('euiFormControlLayout', {
    'euiFormControlLayout--group': isGroup && !isDelimited,
    'euiFormControlLayout-isDisabled': isDisabled,
    'euiFormControlLayout-readOnly': readOnly
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_form_control_layout.euiFormControlLayoutStyles);
  var cssStyles = [styles.euiFormControlLayout, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth].concat((0, _toConsumableArray2.default)(isGroup ? [styles.group.group, compressed ? styles.group.compressed : styles.group.uncompressed] : []));
  var childrenWrapperStyles = [styles.children.euiFormControlLayout__childrenWrapper, isGroup && styles.children.inGroup, isGroup && !append && styles.children.prependOnly, isGroup && !prepend && styles.children.appendOnly, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var hasDropdownIcon = !readOnly && !isDisabled && isDropdown;
  var hasRightIcon = (0, _num_icons.isRightSideIcon)(icon);
  var hasLeftIcon = icon && !hasRightIcon;
  var hasRightIcons = hasRightIcon || clear || isLoading || isInvalid || hasDropdownIcon;
  var iconAffordanceStyles = (0, _react.useMemo)(function () {
    if (iconsPosition === 'static') return; // Static icons don't need padding affordance

    return (0, _num_icons.getIconAffordanceStyles)({
      icon: icon,
      clear: clear,
      isInvalid: isInvalid,
      isLoading: isLoading,
      isDropdown: hasDropdownIcon
    });
  }, [iconsPosition, icon, clear, isInvalid, isLoading, hasDropdownIcon]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)(EuiFormControlLayoutSideNodes, {
    side: "prepend",
    nodes: prepend,
    inputId: inputId,
    compressed: compressed
  }), (0, _react2.jsx)("div", (0, _extends2.default)({}, wrapperProps, {
    css: childrenWrapperStyles,
    className: (0, _classnames.default)('euiFormControlLayout__childrenWrapper', wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className),
    style: _objectSpread(_objectSpread({}, iconAffordanceStyles), wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.style)
  }), hasLeftIcon && (0, _react2.jsx)(_form_control_layout_icons.EuiFormControlLayoutIcons, {
    side: "left",
    icon: icon,
    iconsPosition: iconsPosition,
    compressed: compressed,
    isDisabled: isDisabled
  }), children, hasRightIcons && (0, _react2.jsx)(_form_control_layout_icons.EuiFormControlLayoutIcons, {
    side: "right",
    icon: hasRightIcon ? icon : undefined,
    iconsPosition: iconsPosition,
    compressed: compressed,
    clear: clear,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDropdown: hasDropdownIcon,
    isDisabled: isDisabled
  })), (0, _react2.jsx)(EuiFormControlLayoutSideNodes, {
    side: "append",
    nodes: append,
    inputId: inputId,
    compressed: compressed
  }));
};

/**
 * Internal subcomponent utility for prepend/append nodes
 */
var EuiFormControlLayoutSideNodes = function EuiFormControlLayoutSideNodes(_ref) {
  var side = _ref.side,
    nodes = _ref.nodes,
    inputId = _ref.inputId,
    compressed = _ref.compressed;
  var className = "euiFormControlLayout__".concat(side);
  var styles = (0, _services.useEuiMemoizedStyles)(_form_control_layout.euiFormControlLayoutSideNodeStyles);
  var cssStyles = [styles.euiFormControlLayout__side, styles[side], compressed ? styles.compressed : styles.uncompressed];
  if (!nodes) return null;
  return (0, _react2.jsx)("div", {
    css: cssStyles,
    className: className
  }, _react.default.Children.map(nodes, function (node) {
    return typeof node === 'string' ? (0, _react2.jsx)(_form_label.EuiFormLabel, {
      htmlFor: inputId
    }, node) : node;
  }));
};