"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIconShape = exports.ICON_SIDES = exports.EuiFormControlLayoutIcons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _loading = require("../../loading");
var _form_control_layout_clear_button = require("./form_control_layout_clear_button");
var _form_control_layout_custom_icon = require("./form_control_layout_custom_icon");
var _form_control_layout_icons = require("./form_control_layout_icons.styles");
var _react2 = require("@emotion/react");
var _excluded = ["ref", "side"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var ICON_SIDES = exports.ICON_SIDES = ['left', 'right'];
var isIconShape = exports.isIconShape = function isIconShape(icon) {
  return !!icon && icon.hasOwnProperty('type');
};
var EuiFormControlLayoutIcons = exports.EuiFormControlLayoutIcons = /*#__PURE__*/function (_Component) {
  function EuiFormControlLayoutIcons() {
    (0, _classCallCheck2.default)(this, EuiFormControlLayoutIcons);
    return _callSuper(this, EuiFormControlLayoutIcons, arguments);
  }
  (0, _inherits2.default)(EuiFormControlLayoutIcons, _Component);
  return (0, _createClass2.default)(EuiFormControlLayoutIcons, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        _this$props$side = _this$props.side,
        side = _this$props$side === void 0 ? 'left' : _this$props$side,
        _this$props$iconsPosi = _this$props.iconsPosition,
        iconsPosition = _this$props$iconsPosi === void 0 ? 'absolute' : _this$props$iconsPosi,
        compressed = _this$props.compressed,
        isDisabled = _this$props.isDisabled;
      var customIcon = this.renderCustomIcon();
      var loadingSpinner = this.renderLoadingSpinner();
      var clearButton = this.renderClearButton();
      var invalidIcon = this.renderInvalidIcon();
      var dropdownIcon = this.renderDropdownIcon();
      return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(_form_control_layout_icons.euiFormControlLayoutIconsStyles);
        var cssStyles = [styles.euiFormControlLayoutIcons, compressed ? styles.compressed : styles.uncompressed].concat((0, _toConsumableArray2.default)(iconsPosition === 'absolute' ? [styles.position.absolute.absolute, compressed ? styles.position.absolute.compressed[side] : styles.position.absolute.uncompressed[side]] : [styles.position.static.static, compressed ? styles.position.static.compressed : styles.position.static.uncompressed]), [isDisabled && styles.disabled]);
        return (0, _react2.jsx)("div", {
          css: cssStyles,
          className: "euiFormControlLayoutIcons"
        }, clearButton, loadingSpinner, invalidIcon, customIcon, dropdownIcon);
      });
    }
  }, {
    key: "renderCustomIcon",
    value: function renderCustomIcon() {
      var _this$props2 = this.props,
        icon = _this$props2.icon,
        compressed = _this$props2.compressed,
        isDisabled = _this$props2.isDisabled;
      if (!icon) {
        return null;
      }

      // Normalize the icon to an object if it's a string.
      var iconProps = isIconShape(icon) ? icon : {
        type: icon
      };
      var iconRef = iconProps.ref,
        side = iconProps.side,
        iconRest = (0, _objectWithoutProperties2.default)(iconProps, _excluded);
      return (0, _react2.jsx)(_form_control_layout_custom_icon.EuiFormControlLayoutCustomIcon, (0, _extends2.default)({
        size: compressed ? 's' : 'm',
        disabled: isDisabled,
        iconRef: iconRef
      }, iconRest));
    }
  }, {
    key: "renderDropdownIcon",
    value: function renderDropdownIcon() {
      var _this$props3 = this.props,
        isDropdown = _this$props3.isDropdown,
        compressed = _this$props3.compressed,
        isDisabled = _this$props3.isDisabled;
      if (!isDropdown) {
        return null;
      }
      return (0, _react2.jsx)(_form_control_layout_custom_icon.EuiFormControlLayoutCustomIcon, {
        size: compressed ? 's' : 'm',
        disabled: isDisabled,
        type: "arrowDown"
      });
    }
  }, {
    key: "renderLoadingSpinner",
    value: function renderLoadingSpinner() {
      var _this$props4 = this.props,
        isLoading = _this$props4.isLoading,
        compressed = _this$props4.compressed;
      if (!isLoading) {
        return null;
      }
      return (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
        size: compressed ? 's' : 'm'
      });
    }
  }, {
    key: "renderClearButton",
    value: function renderClearButton() {
      var _this$props5 = this.props,
        clear = _this$props5.clear,
        compressed = _this$props5.compressed,
        isDisabled = _this$props5.isDisabled;
      if (!clear) {
        return null;
      }
      return (0, _react2.jsx)(_form_control_layout_clear_button.EuiFormControlLayoutClearButton, (0, _extends2.default)({
        size: compressed ? 's' : 'm',
        disabled: isDisabled
      }, clear));
    }
  }, {
    key: "renderInvalidIcon",
    value: function renderInvalidIcon() {
      var _this$props6 = this.props,
        isInvalid = _this$props6.isInvalid,
        compressed = _this$props6.compressed;
      if (!isInvalid) {
        return null;
      }
      return (0, _react2.jsx)(_icon.EuiIcon, {
        size: compressed ? 's' : 'm',
        color: "danger",
        type: "warning"
      });
    }
  }]);
}(_react.Component);