"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormLabelStyles = exports.euiFormLabel = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("@emotion/react");
var _serialize = require("@emotion/serialize");
var _global_styling = require("../../../global_styling");
var _title = require("../../title/title.styles");
var _excluded = ["fontWeight"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiFormLabel = exports.euiFormLabel = function euiFormLabel(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  // Exclude the fontWeight from the title, since we're setting our own later
  var _euiTitle = (0, _title.euiTitle)(euiThemeContext, 'xxxs'),
    _ = _euiTitle.fontWeight,
    _titleStyles = (0, _objectWithoutProperties2.default)(_euiTitle, _excluded);
  // Since we're not returning a css`` string (to avoid generating an extra Emotion
  // className), we need to manually serialize the style object into a string
  var titleStyles = (0, _serialize.serializeStyles)([_titleStyles]).styles;
  return "\n    ".concat(titleStyles, "\n    font-weight: ").concat(euiTheme.font.weight.semiBold, ";\n    ").concat((0, _global_styling.euiTextBreakWord)(), "\n  ");
};
var euiFormLabelStyles = exports.euiFormLabelStyles = function euiFormLabelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFormLabel: /*#__PURE__*/(0, _react.css)(euiFormLabel(euiThemeContext), " display:inline-block;", _global_styling.euiCanAnimate, "{transition:color ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";};label:euiFormLabel;"),
    // Skip css`` to avoid generating an extra Emotion className
    // Use :where to reduce specificity & make the CSS easier to override by prepend/append nodes
    notDisabled: "\n      &:where([for]) {\n        cursor: pointer;\n      }\n    ",
    invalid: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.danger, ";;label:invalid;"),
    // Focused state should override invalid state
    focused: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primary, ";;label:focused;")
  };
};