"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRadio = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _radio = require("./radio.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "name", "checked", "label", "value", "onChange", "disabled", "autoFocus", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiRadio = exports.EuiRadio = function EuiRadio(_ref) {
  var className = _ref.className,
    id = _ref.id,
    name = _ref.name,
    checked = _ref.checked,
    label = _ref.label,
    value = _ref.value,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    autoFocus = _ref.autoFocus,
    labelProps = _ref.labelProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiRadio', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_radio.euiRadioStyles);
  var inputStyles = [styles.input.euiRadio__circle, !!label && styles.input.hasLabel, disabled ? checked ? styles.input.disabled.selected : styles.input.disabled.unselected : checked ? styles.input.enabled.selected : styles.input.enabled.unselected];
  var labelClasses = (0, _classnames.default)('euiRadio__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var labelStyles = [styles.label.euiRadio__label, disabled ? styles.label.disabled : styles.label.enabled, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: styles.euiRadio,
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    css: inputStyles,
    className: "euiRadio__circle"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    css: styles.input.euiRadio__icon,
    type: "dot"
  }), (0, _react2.jsx)("input", {
    css: styles.input.euiRadio__input,
    className: "euiRadio__input",
    type: "radio",
    id: id,
    name: name,
    value: value,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    autoFocus: autoFocus
  })), label && (0, _react2.jsx)("label", (0, _extends2.default)({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    htmlFor: id
  }), label));
};