"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeLevels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_levels_colors = require("./range_levels_colors");
var _range_levels = require("./range_levels.styles");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
var _excluded = ["levels", "max", "min", "showTicks", "showRange", "trackWidth"],
  _excluded2 = ["color", "className", "min", "max"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiRangeLevels = exports.EuiRangeLevels = function EuiRangeLevels(_ref) {
  var _ref$levels = _ref.levels,
    levels = _ref$levels === void 0 ? [] : _ref$levels,
    max = _ref.max,
    min = _ref.min,
    showTicks = _ref.showTicks,
    showRange = _ref.showRange,
    trackWidth = _ref.trackWidth,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_levels.euiRangeLevelsStyles)(euiTheme);
  var cssStyles = [styles.euiRangeLevels, showTicks && styles.hasTicks, showRange && styles.hasRange];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: "euiRangeLevels",
    css: cssStyles
  }, rest), levels.map(function (level, index) {
    return (0, _react2.jsx)(EuiRangeLevelElement, {
      key: index,
      level: level,
      min: min,
      max: max,
      trackWidth: trackWidth
    });
  }));
};

// Internal subcomponent
var EuiRangeLevelElement = function EuiRangeLevelElement(_ref2) {
  var level = _ref2.level,
    min = _ref2.min,
    max = _ref2.max,
    trackWidth = _ref2.trackWidth;
  var color = level.color,
    className = level.className,
    levelMin = level.min,
    levelMax = level.max,
    levelRest = (0, _objectWithoutProperties2.default)(level, _excluded2);
  var isNamedColor = (0, _react.useMemo)(function () {
    return (0, _range_levels_colors.isNamedLevelColor)(color);
  }, [color]);
  (0, _react.useEffect)(function () {
    validateLevelIsInRange({
      min: levelMin,
      max: levelMax
    }, {
      min: min,
      max: max
    });
  }, [levelMin, levelMax, min, max]);
  var styles = (0, _react.useMemo)(function () {
    var left = 0;
    var right = 0;
    var leftOffset = 0;
    var rightOffset = 0;
    if (trackWidth > 0) {
      left = levelMin === min ? 0 : (0, _utils.calculateThumbPosition)(levelMin, min, max, trackWidth);
      leftOffset = calculateOffset(left, levelMin, min);
      right = levelMax === max ? 100 : (0, _utils.calculateThumbPosition)(levelMax, min, max, trackWidth);
      rightOffset = calculateOffset(right, levelMax, max);
    }
    return (0, _global_styling.logicalStyles)({
      left: "calc(".concat(left, "% + ").concat(leftOffset, "px)"),
      right: "calc(".concat(100 - right, "% - ").concat(rightOffset, "px)"),
      backgroundColor: !isNamedColor ? color : undefined
    });
  }, [levelMin, levelMax, min, max, trackWidth, isNamedColor, color]);
  var levelClasses = (0, _classnames.default)('euiRangeLevel', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var levelStyles = (0, _range_levels.euiRangeLevelStyles)(euiTheme);
  var cssLevelStyles = [levelStyles.euiRangeLevel, isNamedColor ? levelStyles[color] : levelStyles.customColor];
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    style: styles,
    className: levelClasses,
    css: cssLevelStyles
  }, levelRest));
};
var validateLevelIsInRange = function validateLevelIsInRange(level, _ref3) {
  var min = _ref3.min,
    max = _ref3.max;
  if (level.min < min) {
    throw new Error("The level min of ".concat(level.min, " is lower than the min value of ").concat(min, "."));
  }
  if (level.max > max) {
    throw new Error("The level max of ".concat(level.max, " is higher than the max value of ").concat(max, "."));
  }
};
var calculateOffset = function calculateOffset(position, value, bound) {
  var threshold = 30;
  var offset = value === bound ? 0 : _utils.EUI_THUMB_SIZE / 2;
  if (offset !== 0) {
    // Estimating offset by eye. Trying to account for range scaling at both ends.
    offset = position <= threshold ? offset + 1 / position * threshold : offset;
    offset = position >= 100 - threshold ? offset - 1 / (100 - position) * threshold : offset;
  }
  return offset;
};