"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _eui_form_context = require("../eui_form_context");
var _form_control_layout = require("../form_control_layout");
var _validatable_control = require("../validatable_control");
var _select = require("./select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "options", "id", "name", "inputRef", "isInvalid", "fullWidth", "isLoading", "hasNoInitialSelection", "defaultValue", "compressed", "value", "prepend", "append", "onMouseUp", "disabled"],
  _excluded2 = ["text"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiSelect = exports.EuiSelect = function EuiSelect(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var className = props.className,
    _props$options = props.options,
    options = _props$options === void 0 ? [] : _props$options,
    id = props.id,
    name = props.name,
    inputRef = props.inputRef,
    isInvalid = props.isInvalid,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$hasNoInitialSe = props.hasNoInitialSelection,
    hasNoInitialSelection = _props$hasNoInitialSe === void 0 ? false : _props$hasNoInitialSe,
    defaultValue = props.defaultValue,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    _value = props.value,
    prepend = props.prepend,
    append = props.append,
    onMouseUp = props.onMouseUp,
    disabled = props.disabled,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  // if this is injecting an empty option for `hasNoInitialSelection` then
  // value needs to fallback to an empty string to interact properly with `defaultValue`
  var value = hasNoInitialSelection ? _value !== null && _value !== void 0 ? _value : '' : _value;

  // React HTML input can not have both value and defaultValue properties.
  // https://reactjs.org/docs/uncontrolled-components.html#default-values
  var selectDefaultValue = value != null ? undefined : defaultValue || '';
  var handleMouseUp = (0, _react.useCallback)(function (e) {
    // Normalizes cross-browser mouse eventing by preventing propagation,
    // notably for use in conjunction with EuiOutsideClickDetector.
    // See https://github.com/elastic/eui/pull/1926 for full discussion on
    // rationale and alternatives should this intervention become problematic.
    e.nativeEvent.stopImmediatePropagation();
    onMouseUp === null || onMouseUp === void 0 || onMouseUp(e);
  }, [onMouseUp]);
  var classes = (0, _classnames.default)('euiSelect', {
    'euiSelect-isLoading': isLoading
  }, className);
  var inGroup = !!(prepend || append);
  var styles = (0, _services.useEuiMemoizedStyles)(_select.euiSelectStyles);
  var cssStyles = [styles.euiSelect, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, inGroup && styles.inGroup, styles.lineHeight.removePadding, inGroup ? compressed ? styles.lineHeight.inGroup.compressed : styles.lineHeight.inGroup.uncompressed : compressed ? styles.lineHeight.compressed : styles.lineHeight.uncompressed];
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    isDropdown: true,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    compressed: compressed,
    prepend: prepend,
    append: append,
    inputId: id
  }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
    isInvalid: isInvalid
  }, (0, _react2.jsx)("select", (0, _extends2.default)({
    id: id,
    name: name,
    className: classes,
    css: cssStyles,
    ref: inputRef,
    defaultValue: selectDefaultValue,
    value: value,
    onMouseUp: handleMouseUp,
    disabled: disabled
  }, rest), hasNoInitialSelection && (0, _react2.jsx)("option", {
    value: "",
    disabled: true,
    hidden: true,
    style: {
      display: 'none'
    }
  }, "\xA0"), options.map(function (option, index) {
    var text = option.text,
      rest = (0, _objectWithoutProperties2.default)(option, _excluded2);
    return (0, _react2.jsx)("option", (0, _extends2.default)({}, rest, {
      key: index
    }), text);
  }))));
};