"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSwitch = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _switch = require("./switch.styles");
var _react2 = require("@emotion/react");
var _excluded = ["label", "id", "checked", "disabled", "compressed", "mini", "onChange", "className", "showLabel", "type", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiSwitch = exports.EuiSwitch = function EuiSwitch(_ref) {
  var label = _ref.label,
    id = _ref.id,
    checked = _ref.checked,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    mini = _ref.mini,
    onChange = _ref.onChange,
    className = _ref.className,
    _ref$showLabel = _ref.showLabel,
    showLabel = _ref$showLabel === void 0 ? true : _ref$showLabel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    labelProps = _ref.labelProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var switchId = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });
  var labelId = (0, _services.useGeneratedHtmlId)({
    conditionalId: labelProps === null || labelProps === void 0 ? void 0 : labelProps.id
  });
  var onClick = (0, _react.useCallback)(function (e) {
    if (disabled) {
      return;
    }
    var event = e;
    event.target.checked = !checked;
    onChange(event);
  }, [checked, disabled, onChange]);
  var classes = (0, _classnames.default)('euiSwitch', className);
  var labelClasses = (0, _classnames.default)('euiSwitch__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  if (showLabel === false && typeof label !== 'string') {
    console.warn('EuiSwitch `label` must be a string when `showLabel` is false.');
  }
  var size = mini ? 'mini' : compressed ? 'compressed' : 'uncompressed';
  var styles = (0, _services.useEuiMemoizedStyles)(_switch.euiSwitchStyles);
  var cssStyles = [styles.euiSwitch, disabled ? styles.disabled : styles.enabled];
  var buttonStyles = [styles.button.euiSwitch__button, styles.button[size]];
  var bodyStyles = [styles.body.euiSwitch__body, disabled ? styles.body.disabled[size] : checked ? styles.body.on : styles.body.off];
  var iconsStyles = [styles.icons.euiSwitch__icons, checked ? styles.icons.on : styles.icons.off, disabled ? styles.icons.disabled : styles.icons.enabled];
  var thumbStyles = [styles.thumb.euiSwitch__thumb, checked ? styles.thumb.on[size] : styles.thumb.off].concat((0, _toConsumableArray2.default)(disabled ? [styles.thumb.disabled.disabled, styles.thumb.disabled[size]] : [styles.thumb.enabled.enabled, styles.thumb.enabled[size]]));
  var labelStyles = [styles.label.euiSwitch__label, styles.label[size], disabled && styles.label.disabled, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  return (0, _react2.jsx)("div", {
    css: cssStyles,
    className: classes
  }, (0, _react2.jsx)("button", (0, _extends2.default)({
    id: switchId,
    "aria-checked": checked || false,
    css: buttonStyles,
    className: "euiSwitch__button",
    role: "switch",
    type: type,
    disabled: disabled,
    onClick: onClick,
    "aria-label": showLabel ? undefined : label,
    "aria-labelledby": showLabel ? labelId : undefined
  }, rest), (0, _react2.jsx)("span", {
    css: bodyStyles,
    className: "euiSwitch__body"
  }, !(compressed || mini) && (0, _react2.jsx)("span", {
    css: iconsStyles,
    className: "euiSwitch__icons"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "check",
    size: "m"
  }), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "cross",
    size: "m"
  }))), (0, _react2.jsx)("span", {
    css: thumbStyles,
    className: "euiSwitch__thumb"
  })), showLabel &&
  // <button> + <label> has poor screen reader support.
  // Click handler added to simulate natural, secondary <label> interactivity.
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  (0, _react2.jsx)("span", (0, _extends2.default)({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    id: labelId,
    onClick: onClick
  }), label));
};