"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESIZE = exports.EuiTextArea = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _form_control_layout = require("../form_control_layout");
var _validatable_control = require("../validatable_control");
var _eui_form_context = require("../eui_form_context");
var _text_area = require("./text_area.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "compressed", "fullWidth", "id", "icon", "inputRef", "isLoading", "isInvalid", "isClearable", "name", "placeholder", "resize", "rows"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var RESIZE = exports.RESIZE = ['vertical', 'horizontal', 'both', 'none'];
var EuiTextArea = exports.EuiTextArea = function EuiTextArea(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var children = props.children,
    className = props.className,
    compressed = props.compressed,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    id = props.id,
    icon = props.icon,
    inputRef = props.inputRef,
    isLoading = props.isLoading,
    isInvalid = props.isInvalid,
    isClearable = props.isClearable,
    name = props.name,
    placeholder = props.placeholder,
    _props$resize = props.resize,
    resize = _props$resize === void 0 ? 'vertical' : _props$resize,
    rows = props.rows,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var classes = (0, _classnames.default)('euiTextArea', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_text_area.euiTextAreaStyles);
  var cssStyles = [styles.euiTextArea, styles.resize[resize], compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth];
  var ref = (0, _react.useRef)(null);
  var refs = (0, _services.useCombinedRefs)([ref, inputRef]);
  var clear = (0, _react.useMemo)(function () {
    if (isClearable) {
      return {
        onClick: function onClick() {
          if (ref.current) {
            // Updates the displayed value and fires `onChange` callbacks
            // @see https://stackoverflow.com/questions/23892547/what-is-the-best-way-to-trigger-onchange-event-in-react-js
            var nativeValueSetter = Object.getOwnPropertyDescriptor(window.HTMLTextAreaElement.prototype, 'value').set;
            nativeValueSetter.call(ref.current, '');
            var event = new Event('input', {
              bubbles: true,
              cancelable: false
            });
            ref.current.dispatchEvent(event);

            // Set focus back to the textarea
            ref.current.focus();
          }
        },
        'data-test-subj': 'clearTextAreaButton'
      };
    }
  }, [isClearable]);
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: rest.disabled,
    clear: clear,
    icon: icon,
    className: "euiFormControlLayout--euiTextArea",
    css: styles.formControlLayout.euiTextArea
  }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
    isInvalid: isInvalid
  }, (0, _react2.jsx)("textarea", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest, {
    rows: rows ? rows : compressed ? 3 : 6,
    name: name,
    id: id,
    ref: refs,
    placeholder: placeholder
  }), children)));
};