"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _avatar = require("../avatar");
var _flex = require("../flex");
var _header_breadcrumbs = require("./header_breadcrumbs");
var _header = require("./header");
var _header_logo = require("./header_logo");
var _header_section = require("./header_section");
var _icon = require("../icon");
var _key_pad_menu = require("../key_pad_menu");
var _link = require("../link");
var _popover = require("../popover");
var _selectable = require("../selectable");
var _spacer = require("../spacer");
var _text = require("../text");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Header = function Header() {
  var renderLogo = function renderLogo() {
    return (0, _react2.jsx)(_header_logo.EuiHeaderLogo, {
      iconType: "logoElastic",
      href: "#",
      onClick: function onClick(e) {
        return e.preventDefault();
      },
      "aria-label": "Go to home page"
    });
  };
  var renderBreadcrumbs = function renderBreadcrumbs() {
    var breadcrumbs = [{
      text: 'Management',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      },
      'data-test-subj': 'breadcrumbsAnimals',
      className: 'customClass'
    }, {
      text: 'Truncation test is here for a really long item',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Hidden',
      'data-test-subj': 'cy-breadcrumb-hidden',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Users',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Create'
    }];
    return (0, _react2.jsx)(_header_breadcrumbs.EuiHeaderBreadcrumbs, {
      "aria-label": "Header breadcrumbs example",
      breadcrumbs: breadcrumbs
    });
  };
  var search = (0, _react2.jsx)(_selectable.EuiSelectableTemplateSitewide, {
    options: [],
    searchProps: {
      compressed: true
    },
    popoverButton: (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
      "aria-label": "Sitewide search"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: "search",
      size: "m"
    })),
    emptyMessage: (0, _react2.jsx)(_selectable.EuiSelectableMessage, {
      style: {
        minHeight: 300
      },
      "data-test-subj": "cy-search-menu"
    }, (0, _react2.jsx)("p", null, "Please see the component page for", ' ', (0, _react2.jsx)("strong", null, "EuiSelectableTemplateSitewide"), "on how to configure your sitewide search."))
  });
  return (0, _react2.jsx)(_header.EuiHeader, null, (0, _react2.jsx)(_header_section.EuiHeaderSection, {
    grow: false
  }, (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, renderLogo()), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, (0, _react2.jsx)(HeaderSpacesMenu, null))), renderBreadcrumbs(), (0, _react2.jsx)(_header_section.EuiHeaderSection, {
    side: "right"
  }, (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, search), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, (0, _react2.jsx)(HeaderUserMenu, null)), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, (0, _react2.jsx)(HeaderAppMenu, null))));
};
var HeaderUserMenu = function HeaderUserMenu() {
  var headerUserPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerUserPopover'
  });
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerUserPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Account menu",
    onClick: onMenuButtonClick
  }, (0, _react2.jsx)(_avatar.EuiAvatar, {
    name: "John Username",
    size: "s"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerUserPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu,
    panelPaddingSize: "none",
    "data-test-subj": "cy-account-menu"
  }, (0, _react2.jsx)("div", {
    style: {
      width: 320
    }
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "m",
    className: "euiHeaderProfile",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_avatar.EuiAvatar, {
    name: "John Username",
    size: "xl"
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "John Username")), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, null, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_link.EuiLink, null, "Edit profile")), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_link.EuiLink, null, "Log out")))))))));
};
var HeaderSpacesMenu = function HeaderSpacesMenu() {
  var headerSpacesPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerSpacesPopover'
  });
  var spacesValues = [{
    label: 'Sales team',
    prepend: (0, _react2.jsx)(_avatar.EuiAvatar, {
      type: "space",
      name: "Sales Team",
      size: "s"
    }),
    checked: 'on'
  }, {
    label: 'Engineering',
    prepend: (0, _react2.jsx)(_avatar.EuiAvatar, {
      type: "space",
      name: "Engineering",
      size: "s"
    })
  }];
  var _useState3 = (0, _react.useState)(spacesValues),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    spaces = _useState4[0],
    setSpaces = _useState4[1];
  var _useState5 = (0, _react.useState)(spaces.filter(function (option) {
      return option.checked;
    })[0]),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    selectedSpace = _useState6[0],
    setSelectedSpace = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    isOpen = _useState8[0],
    setIsOpen = _useState8[1];
  var isListExtended = function isListExtended() {
    return spaces.length > 4 ? true : false;
  };
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closePopover = function closePopover() {
    setIsOpen(false);
  };
  var onChange = function onChange(options) {
    setSpaces(options);
    setSelectedSpace(options.filter(function (option) {
      return option.checked;
    })[0]);
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerSpacesPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Spaces menu",
    onClick: onMenuButtonClick
  }, selectedSpace.prepend);
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerSpacesPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downLeft",
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, (0, _react2.jsx)(_selectable.EuiSelectable, {
    searchable: isListExtended(),
    searchProps: {
      placeholder: 'Find a space',
      compressed: true
    },
    options: spaces,
    singleSelection: "always",
    style: {
      width: 300
    },
    onChange: onChange,
    listProps: {
      rowHeight: 40,
      showIcons: false
    },
    "data-test-subj": "cy-spaces-menu"
  }, function (list, search) {
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, search || 'Your spaces'), list);
  }));
};
var HeaderAppMenu = function HeaderAppMenu() {
  var headerAppPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerAppPopover'
  });
  var headerAppKeyPadMenuId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerAppKeyPadMenu'
  });
  var _useState9 = (0, _react.useState)(false),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    isOpen = _useState10[0],
    setIsOpen = _useState10[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerAppKeyPadMenuId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Apps menu with 1 new app",
    notification: "1",
    onClick: onMenuButtonClick
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "apps",
    size: "m"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerAppPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenu, {
    id: headerAppKeyPadMenuId,
    style: {
      width: 288
    },
    "data-test-subj": "cy-apps-menu"
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Discover"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "discoverApp",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Dashboard"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "dashboardApp",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Dev Tools"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "devToolsApp",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(Header, null));
});
describe('EuiHeader', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when Spaces menu is expanded', function () {
      cy.get('button[aria-label="Spaces menu"]').realClick();
      cy.get('div[data-test-subj="cy-spaces-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Account menu is expanded', function () {
      cy.get('button[aria-label="Account menu"]').realClick();
      cy.get('div[data-test-subj="cy-account-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Sitewide search is expanded', function () {
      cy.get('button[aria-label="Sitewide search"]').realClick();
      cy.get('div[data-test-subj="cy-search-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Apps menu is expanded', function () {
      cy.get('button[aria-label="Apps menu with 1 new app"]').realClick();
      cy.get('ul[data-test-subj="cy-apps-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when a hidden breadcrumb is expanded', function () {
      cy.get('button[title="See collapsed breadcrumbs"]').realClick();
      cy.get('a[data-test-subj="cy-breadcrumb-hidden"]').should('exist');
      cy.checkAxe();
    });
  });
});