"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiHeaderLinks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _header_section = require("../header_section");
var _responsive = require("../../responsive");
var _header_links = require("./header_links.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "gutterSize", "popoverBreakpoints", "popoverButtonProps", "popoverProps"],
  _excluded2 = ["onClick", "iconType"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var GUTTER_SIZES = exports.GUTTER_SIZES = ['xxs', 'xs', 's', 'm', 'l'];
var EuiHeaderLinks = exports.EuiHeaderLinks = function EuiHeaderLinks(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$popoverBreakpoin = _ref.popoverBreakpoints,
    popoverBreakpoints = _ref$popoverBreakpoin === void 0 ? ['xs', 's'] : _ref$popoverBreakpoin,
    popoverButtonProps = _ref.popoverButtonProps,
    popoverProps = _ref.popoverProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _header_links.euiHeaderLinksStyles)(euiTheme);
  var _ref2 = popoverButtonProps || {},
    onClick = _ref2.onClick,
    _ref2$iconType = _ref2.iconType,
    iconType = _ref2$iconType === void 0 ? 'apps' : _ref2$iconType,
    popoverButtonRest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    mobileMenuIsOpen = _useState2[0],
    setMobileMenuIsOpen = _useState2[1];
  var onMenuButtonClick = (0, _react.useCallback)(function (e) {
    onClick === null || onClick === void 0 || onClick(e);
    setMobileMenuIsOpen(function (mobileMenuIsOpen) {
      return !mobileMenuIsOpen;
    });
  }, [onClick]);
  var closeMenu = (0, _react.useCallback)(function () {
    setMobileMenuIsOpen(false);
  }, []);
  (0, _react.useEffect)(function () {
    window.addEventListener('resize', closeMenu);
    return function () {
      window.removeEventListener('resize', closeMenu);
    };
  }, [closeMenu]);
  var classes = (0, _classnames.default)('euiHeaderLinks', className);
  var button = (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiHeaderLinks.openNavigationMenu",
    default: "Open menu"
  }, function (openNavigationMenu) {
    return (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, (0, _extends2.default)({
      "aria-label": openNavigationMenu,
      onClick: onMenuButtonClick
    }, popoverButtonRest), (0, _react2.jsx)(_icon.EuiIcon, {
      type: iconType,
      size: "m"
    }));
  });
  var renderedChildren = typeof children === 'function' ? children(closeMenu) : children;
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiHeaderLinks.appNavigation",
    default: "App menu"
  }, function (appNavigation) {
    return (0, _react2.jsx)("nav", (0, _extends2.default)({
      className: classes,
      css: styles.euiHeaderLinks,
      "aria-label": appNavigation
    }, rest), (0, _react2.jsx)(_responsive.EuiHideFor, {
      sizes: popoverBreakpoints
    }, (0, _react2.jsx)("div", {
      className: "euiHeaderLinks__list",
      css: [styles.euiHeaderLinks__list, styles.gutterSizes[gutterSize], ";label:EuiHeaderLinks;"]
    }, renderedChildren)), (0, _react2.jsx)(_responsive.EuiShowFor, {
      sizes: popoverBreakpoints
    }, (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({
      button: button,
      isOpen: mobileMenuIsOpen,
      anchorPosition: "downRight",
      closePopover: closeMenu,
      panelPaddingSize: "s",
      repositionOnScroll: true
    }, popoverProps), (0, _react2.jsx)("div", {
      className: "euiHeaderLinks__mobileList",
      css: styles.euiHeaderLinks__mobileList
    }, renderedChildren))));
  });
};