"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeaderSectionItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _header_section_item = require("./header_section_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Header items are small icon links that pop up menus
 */
var EuiHeaderSectionItem = exports.EuiHeaderSectionItem = function EuiHeaderSectionItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _header_section_item.euiHeaderSectionItemStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiHeaderSectionItem', className);

  // we check if there is any children and if not, we don't render anything
  return children ? (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: styles.euiHeaderSectionItem
  }, rest), children) : null;
};