"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT_SIZES = exports.EuiHealth = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _flex = require("../flex");
var _health = require("./health.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "color", "textSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var TEXT_SIZES = exports.TEXT_SIZES = ['xs', 's', 'm', 'inherit'];
var EuiHealth = exports.EuiHealth = function EuiHealth(_ref) {
  var children = _ref.children,
    className = _ref.className,
    color = _ref.color,
    _ref$textSize = _ref.textSize,
    textSize = _ref$textSize === void 0 ? 's' : _ref$textSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_health.euiHealthStyles);
  var cssStyles = [styles.euiHealth, styles[textSize]];
  var classes = (0, _classnames.default)('euiHealth', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "dot",
    color: color
  })), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, children)));
};