"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHighlight = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _mark = require("../mark");
var _highlight_all = require("./_highlight_all");
var _highlight_first = require("./_highlight_first");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "search", "strict", "highlightAll", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiHighlight = exports.EuiHighlight = function EuiHighlight(_ref) {
  var children = _ref.children,
    className = _ref.className,
    search = _ref.search,
    _ref$strict = _ref.strict,
    strict = _ref$strict === void 0 ? false : _ref$strict,
    _ref$highlightAll = _ref.highlightAll,
    highlightAll = _ref$highlightAll === void 0 ? false : _ref$highlightAll,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var hasSearch = search && search.length > 0;
  var HighlightComponent = (0, _react.useMemo)(function () {
    var Component = function Component(_ref2) {
      var children = _ref2.children;
      return (0, _react2.jsx)(_mark.EuiMark, {
        hasScreenReaderHelpText: hasScreenReaderHelpText
      }, children);
    };
    Component.displayName = '_HighlightComponent';
    return Component;
  }, [hasScreenReaderHelpText]);
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: className
  }, rest), children && hasSearch ? highlightAll ? (0, _react2.jsx)(_highlight_all.HighlightAll, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : (0, _react2.jsx)(_highlight_first.HighlightFirst, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : children);
};