"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "COLORS", {
  enumerable: true,
  get: function get() {
    return _named_colors.COLORS;
  }
});
exports.clearIconComponentCache = exports.appendIconComponentCache = exports.TYPES = exports.SIZES = exports.EuiIconClass = exports.EuiIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _icon_map = require("./icon_map");
var _empty = require("./assets/empty");
var _react2 = require("../../services/react");
var _services = require("../../services");
var _named_colors = require("./named_colors");
var _icon = require("./icon.styles");
var _react3 = require("@emotion/react");
var _excluded = ["type", "size", "color", "className", "tabIndex", "title", "onIconLoad", "style", "stylesMemoizer"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var getIsAppIcon = function getIsAppIcon(iconType) {
  if (typeof iconType !== 'string') return false;
  if (iconType === 'dataVisualizer') return true; // Special case
  if (iconType.indexOf('data:') === 0) return false; // Inline data URIs should be short-circuited for performance
  return iconType.endsWith('App') || iconType.endsWith('Job');
};
var TYPES = exports.TYPES = (0, _common.keysOf)(_icon_map.typeToPathMap);

// We accept arbitrary color strings, which are impossible to type.

var SIZES = exports.SIZES = ['original', 's', 'm', 'l', 'xl', 'xxl'];
function isEuiIconType(x) {
  return typeof x === 'string' && _icon_map.typeToPathMap.hasOwnProperty(x);
}
function getInitialIcon(icon) {
  if (icon == null) {
    return undefined;
  }
  if (isEuiIconType(icon)) {
    if (iconComponentCache.hasOwnProperty(icon)) {
      return iconComponentCache[icon];
    }
    return undefined;
  }
  return icon;
}
var generateId = (0, _services.htmlIdGenerator)();
var iconComponentCache = {};
var clearIconComponentCache = exports.clearIconComponentCache = function clearIconComponentCache(iconType) {
  if (iconType != null) {
    delete iconComponentCache[iconType];
  } else {
    iconComponentCache = {};
  }
};
var appendIconComponentCache = exports.appendIconComponentCache = function appendIconComponentCache(iconTypeToIconComponentMap) {
  for (var iconType in iconTypeToIconComponentMap) {
    if (iconTypeToIconComponentMap.hasOwnProperty(iconType)) {
      iconComponentCache[iconType] = iconTypeToIconComponentMap[iconType];
    }
  }
};
var EuiIconClass = exports.EuiIconClass = /*#__PURE__*/function (_PureComponent) {
  function EuiIconClass(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiIconClass);
    _this = _callSuper(this, EuiIconClass, [props]);
    (0, _defineProperty2.default)(_this, "isMounted", false);
    (0, _defineProperty2.default)(_this, "loadIconComponent", function (iconType) {
      if (iconComponentCache.hasOwnProperty(iconType)) {
        // exists in cache
        _this.setState({
          isLoading: false,
          neededLoading: false,
          icon: iconComponentCache[iconType]
        });
        _this.onIconLoad();
        return;
      }
      (function (specifier) {
        return new Promise(function (r) {
          return r("".concat(specifier));
        }).then(function (s) {
          return _interopRequireWildcard(require(s));
        });
      })( /* webpackChunkName: "icon.[request]" */
      // It's important that we don't use a template string here, it
      // stops webpack from building a dynamic require context.
      // eslint-disable-next-line prefer-template
      './assets/' + _icon_map.typeToPathMap[iconType]).then(function (_ref) {
        var icon = _ref.icon;
        iconComponentCache[iconType] = icon;
        (0, _react2.enqueueStateChange)(function () {
          if (_this.isMounted && _this.props.type === iconType) {
            _this.setState({
              icon: icon,
              iconTitle: iconType,
              isLoading: false
            }, _this.onIconLoad);
          }
        });
      });
    });
    (0, _defineProperty2.default)(_this, "onIconLoad", function () {
      var onIconLoad = _this.props.onIconLoad;
      if (onIconLoad) {
        onIconLoad();
      }
    });
    var type = props.type;
    var initialIcon = getInitialIcon(type);
    _this.state = {
      icon: initialIcon,
      iconTitle: undefined,
      isLoading: false,
      neededLoading: false
    };
    return _this;
  }
  (0, _inherits2.default)(EuiIconClass, _PureComponent);
  return (0, _createClass2.default)(EuiIconClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.isMounted = true;
      var type = this.props.type;
      if (isEuiIconType(type) && this.state.icon == null) {
        this.setState({
          neededLoading: true,
          isLoading: true
        });
        this.loadIconComponent(type);
      } else {
        this.onIconLoad();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var type = this.props.type;
      if (type !== prevProps.type) {
        if (isEuiIconType(type)) {
          this.setState({
            neededLoading: iconComponentCache.hasOwnProperty(type),
            isLoading: true
          });
          this.loadIconComponent(type);
        } else {
          this.setState({
            icon: type,
            neededLoading: true,
            isLoading: false
          });
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.isMounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        type = _this$props.type,
        _this$props$size = _this$props.size,
        size = _this$props$size === void 0 ? 'm' : _this$props$size,
        color = _this$props.color,
        className = _this$props.className,
        tabIndex = _this$props.tabIndex,
        title = _this$props.title,
        onIconLoad = _this$props.onIconLoad,
        style = _this$props.style,
        stylesMemoizer = _this$props.stylesMemoizer,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var _this$state = this.state,
        isLoading = _this$state.isLoading,
        neededLoading = _this$state.neededLoading,
        iconTitle = _this$state.iconTitle;
      var isLoaded = !isLoading && neededLoading;
      var isCustomColor = color && !(0, _named_colors.isNamedColor)(color);
      var optionalCustomStyles = isCustomColor ? _objectSpread({
        color: color
      }, style) : style;

      // These icons are a little special and get some extra CSS flexibility
      var isAppIcon = getIsAppIcon(type);
      // App color styles are only applied if no color is passed or if color="default" is passed
      var appIconHasColor = color && color !== 'default';

      // The Elastic logo should be an outline in text and ghost mode
      var isElasticLogoOutline = type === 'logoElastic' && (color === 'ghost' || color === 'text');
      var classes = (0, _classnames.default)('euiIcon', className);

      // Emotion styles
      var styles = stylesMemoizer(_icon.euiIconStyles);
      var cssStyles = [styles.euiIcon, styles[size], color && (0, _named_colors.isNamedColor)(color) && styles[color], isCustomColor && styles.customColor, isElasticLogoOutline && styles.logoElasticOutline, isAppIcon && !appIconHasColor && styles.app, isLoading && styles.isLoading, !isLoading && neededLoading && styles.isLoaded];
      var icon = this.state.icon || _empty.icon;
      if (typeof icon === 'string') {
        return (0, _react3.jsx)("img", (0, _extends2.default)({
          alt: title ? title : '',
          src: icon,
          className: classes,
          css: cssStyles,
          style: style,
          tabIndex: tabIndex
        }, rest));
      } else {
        var Svg = icon;

        // If there is no aria-label, aria-labelledby, or title it gets aria-hidden true
        var isAriaHidden = !(this.props['aria-label'] || this.props['aria-labelledby'] || this.props.title);

        // If no aria-label or aria-labelledby is provided but there's a title, a titleId is generated
        //  The svg aria-labelledby attribute gets this titleId
        //  The svg title element gets this titleId as an id
        var titleId = !this.props['aria-label'] && !this.props['aria-labelledby'] && title ? {
          titleId: generateId()
        } : undefined;
        return (0, _react3.jsx)(Svg, (0, _extends2.default)({
          className: classes,
          style: optionalCustomStyles,
          css: cssStyles,
          tabIndex: tabIndex,
          role: "img",
          title: title
        }, titleId, {
          "data-icon-type": iconTitle,
          "data-is-loaded": isLoaded || undefined,
          "data-is-loading": isLoading || undefined
        }, rest, {
          "aria-hidden": isAriaHidden || rest['aria-hidden']
        }));
      }
    }
  }]);
}(_react.PureComponent);
var EuiIcon = exports.EuiIcon = (0, _services.withEuiStylesMemoizer)(EuiIconClass);