"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _react = _interopRequireDefault(require("react"));
var _icon = require("./icon");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

describe('EuiIcons', function () {
  describe('Automated accessibility check for glyph icons', function () {
    var GlyphIcons = ['accessibility', 'aggregate', 'analyzeEvent', 'annotation', 'apmTrace', 'apps', 'arrowDown', 'arrowLeft', 'arrowRight', 'arrowUp', 'arrowStart', 'arrowEnd', 'article', 'asterisk', 'beaker', 'bell', 'bellSlash', 'beta', 'bolt', 'boxesHorizontal', 'boxesVertical', 'branch', 'branchUser', 'broom', 'brush', 'bug', 'bullseye', 'calendar', 'check', 'checkInCircleFilled', 'cheer', 'clock', 'cloudDrizzle', 'cloudStormy', 'cloudSunny', 'cluster', 'color', 'compute', 'console', 'container', 'continuityAbove', 'continuityAboveBelow', 'continuityBelow', 'continuityWithin', 'controlsHorizontal', 'controlsVertical', 'copy', 'copyClipboard', 'cross', 'crosshairs', 'currency', 'cut', 'database', 'desktop', 'discuss', 'document', 'documents', 'documentEdit', 'documentation', 'dot', 'dotInCircle', 'doubleArrowLeft', 'doubleArrowRight', 'download', 'email', 'empty', 'eql', 'eraser', 'exit', 'expand', 'expandMini', 'exportAction', 'eye', 'eyeClosed', 'faceHappy', 'faceNeutral', 'faceSad', 'filter', 'filterExclude', 'filterIgnore', 'filterInclude', 'filterInCircle', 'flag', 'fold', 'folderCheck', 'folderClosed', 'folderExclamation', 'folderOpen', 'frameNext', 'framePrevious', 'fullScreen', 'fullScreenExit', 'function', 'gear', 'glasses', 'globe', 'grab', 'grabHorizontal', 'grid', 'heart', 'heatmap', 'help', 'home', 'iInCircle', 'image', 'importAction', 'indexClose', 'indexEdit', 'indexFlush', 'indexMapping', 'indexOpen', 'indexRuntime', 'indexSettings', 'indexTemporary', 'infinity', 'inputOutput', 'inspect', 'invert', 'ip', 'keyboard', 'kqlField', 'kqlFunction', 'kqlOperand', 'kqlSelector', 'kqlValue', 'kubernetesNode', 'kubernetesPod', 'launch', 'layers', 'lettering', 'lineDashed', 'lineDotted', 'lineSolid', 'link', 'list', 'listAdd', 'lock', 'lockOpen', 'logstashFilter', 'logstashIf', 'logstashInput', 'logstashOutput', 'logstashQueue', 'magnifyWithExclamation', 'magnifyWithMinus', 'magnifyWithPlus', 'magnet', 'mapMarker', 'memory', 'merge', 'menu', 'menuDown', 'menuLeft', 'menuRight', 'menuUp', 'minimize', 'minus', 'minusInCircle', 'minusInCircleFilled', 'mobile', 'moon', 'namespace', 'nested', 'node', 'number', 'offline', 'online', 'package', 'pageSelect', 'pagesSelect', 'paperClip', 'partial', 'pause', 'payment', 'pencil', 'percent', 'pin', 'pinFilled', 'play', 'playFilled', 'plus', 'plusInCircle', 'plusInCircleFilled', 'popout', 'push', 'questionInCircle', 'quote', 'refresh', 'reporter', 'returnKey', 'save', 'scale', 'search', 'securitySignal', 'securitySignalDetected', 'securitySignalResolved', 'sessionViewer', 'shard', 'share', 'snowflake', 'sortable', 'sortAscending', 'sortDescending', 'sortDown', 'sortLeft', 'sortRight', 'sortUp', 'spaces', 'sparkles', 'starEmpty', 'starEmptySpace', 'starFilled', 'starFilledSpace', 'starMinusEmpty', 'starMinusFilled', 'starPlusEmpty', 'starPlusFilled', 'stats', 'stop', 'stopFilled', 'stopSlash', 'storage', 'string', 'submodule', 'sun', 'symlink', 'tableOfContents', 'tableDensityExpanded', 'tableDensityCompact', 'tableDensityNormal', 'tag', 'tear', 'temperature', 'timeline', 'timelineWithArrow', 'timeRefresh', 'timeslider', 'training', 'trash', 'unfold', 'unlink', 'user', 'userAvatar', 'users', 'vector', 'videoPlayer', 'visArea', 'visAreaStacked', 'visBarHorizontal', 'visBarHorizontalStacked', 'visBarVertical', 'visBarVerticalStacked', 'visGauge', 'visGoal', 'visLine', 'visMapCoordinate', 'visMapRegion', 'visMetric', 'visPie', 'visTable', 'visTagCloud', 'visText', 'visTimelion', 'visVega', 'visVisualBuilder', 'warning', 'wordWrap', 'wordWrapDisabled', 'wrench'];
    var GlyphGrid = function GlyphGrid() {
      return (0, _react2.jsx)("div", null, GlyphIcons.map(function (glyph) {
        return (0, _react2.jsx)(_icon.EuiIcon, {
          className: "eui-alignMiddle",
          type: glyph
        });
      }));
    };
    it('has zero violations on first render', function () {
      cy.mount((0, _react2.jsx)(GlyphGrid, null));
      cy.get('svg[data-icon-type="wrench"]', {
        timeout: 5000
      }).should('exist');
      cy.checkAxe();
    });
  });
});