"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _icon = require("../icon");
var _accessibility = require("../accessibility");
var _image_button = require("./image_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["hasAlt", "hasShadow", "children", "onClick", "onKeyDown", "isFullScreen", "isFullWidth", "fullScreenIconColor"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};
var EuiImageButton = exports.EuiImageButton = function EuiImageButton(_ref) {
  var hasAlt = _ref.hasAlt,
    hasShadow = _ref.hasShadow,
    children = _ref.children,
    onClick = _ref.onClick,
    onKeyDown = _ref.onKeyDown,
    isFullScreen = _ref.isFullScreen,
    isFullWidth = _ref.isFullWidth,
    _ref$fullScreenIconCo = _ref.fullScreenIconColor,
    fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var buttonStyles = (0, _image_button.euiImageButtonStyles)(euiTheme);
  var cssButtonStyles = [buttonStyles.euiImageButton, hasShadow ? buttonStyles.hasShadowHover : buttonStyles.shadowHover, !isFullScreen && isFullWidth && buttonStyles.fullWidth];
  var iconStyles = (0, _image_button.euiImageButtonIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.openFullScreen];
  var openFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.openFullScreen', 'Click to open this image in fullscreen mode');
  var closeFullScreenInstructions = (0, _i18n.useEuiI18n)('euiImageButton.closeFullScreen', 'Press Escape or click to close image fullscreen mode');
  var iconColor = fullScreenIconColorMap[fullScreenIconColor];
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("button", (0, _extends2.default)({
    type: "button",
    css: cssButtonStyles,
    onClick: onClick,
    onKeyDown: onKeyDown
  }, rest), isFullScreen &&
  // In fullscreen mode, instructions should come first to allow screen reader
  // users to quickly exit vs. potentially reading out long/unskippable alt text
  (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, closeFullScreenInstructions, hasAlt && ' — ')), children, !isFullScreen && (0, _react2.jsx)("div", {
    css: cssIconStyles
  }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, hasAlt && ' — ', openFullScreenInstructions)), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "fullScreen",
    color: iconColor
  }))));
};