"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageFullScreenWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _icon = require("../icon");
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _image_fullscreen_wrapper = require("./image_fullscreen_wrapper.styles");
var _image_button = require("./image_button");
var _image_button2 = require("./image_button.styles");
var _image_caption = require("./image_caption");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiImageFullScreenWrapper = exports.EuiImageFullScreenWrapper = function EuiImageFullScreenWrapper(_ref) {
  var alt = _ref.alt,
    hasShadow = _ref.hasShadow,
    caption = _ref.caption,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    isFullWidth = _ref.isFullWidth,
    fullScreenIconColor = _ref.fullScreenIconColor,
    onFullScreen = _ref.onFullScreen;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_fullscreen_wrapper.euiImageFullscreenWrapperStyles)(euiTheme);
  var cssStyles = [styles.euiImageFullscreenWrapper, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var classes = (0, _classnames.default)('euiImageFullScreenWrapper', wrapperProps && wrapperProps.className);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };
  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(false);
  };
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  var iconStyles = (0, _image_button2.euiImageButtonIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.closeFullScreen];
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, {
    "data-test-subj": "fullScreenOverlayMask"
  }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    onClickOutside: closeFullScreen
  }, (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("figure", (0, _extends2.default)({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssStyles
  }), (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: closeFullScreen,
    onKeyDown: onKeyDown,
    "data-test-subj": "deactivateFullScreenButton",
    isFullScreen: true,
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children), (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    caption: caption,
    ref: optionalCaptionRef,
    isOnOverlayMask: true
  })), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "fullScreenExit",
    color: "ghost",
    css: cssIconStyles
  }))));
};