"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInlineEditText = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _text = require("../text");
var _inline_edit_form = require("./inline_edit_form");
var _inline_edit_text = require("./inline_edit_text.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "size", "readModeProps", "isReadOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiInlineEditText = exports.EuiInlineEditText = function EuiInlineEditText(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _readModeProps = _ref.readModeProps,
    isReadOnly = _ref.isReadOnly,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInlineEditText', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_inline_edit_text.euiInlineEditTextStyles);
  var cssStyles = [styles.euiInlineEditText, styles.fontSize[size]];
  var isSmallSize = ['xs', 's'].includes(size);
  var sizes = isSmallSize ? _inline_edit_form.SMALL_SIZE_FORM : _inline_edit_form.MEDIUM_SIZE_FORM;
  var readModeProps = (0, _react.useMemo)(function () {
    if (!isReadOnly) return _readModeProps;
    return _objectSpread(_objectSpread({}, _readModeProps), {}, {
      role: 'paragraph'
    });
  }, [_readModeProps, isReadOnly]);
  return (0, _react2.jsx)(_inline_edit_form.EuiInlineEditForm, (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    readModeProps: readModeProps,
    isReadOnly: isReadOnly,
    sizes: sizes
  }, rest), function (textReadModeValue) {
    return (0, _react2.jsx)(_text.EuiText, {
      size: size,
      className: "eui-textTruncate"
    }, textReadModeValue);
  });
};