"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _form_label = require("../form/form_label/form_label");
var _key_pad_menu = require("./key_pad_menu.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "checkable"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiKeyPadMenu = exports.EuiKeyPadMenu = function EuiKeyPadMenu(_ref) {
  var _checkable$legendProp;
  var children = _ref.children,
    className = _ref.className,
    checkable = _ref.checkable,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var hasCheckableConfig = (0, _typeof2.default)(checkable) === 'object';
  var classes = (0, _classnames.default)('euiKeyPadMenu', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_key_pad_menu.euiKeyPadMenuStyles);
  var cssStyles = [styles.euiKeyPadMenu];
  var legendCssStyles = [styles.euiKeyPadMenu__legend, hasCheckableConfig && (checkable === null || checkable === void 0 || (_checkable$legendProp = checkable.legendProps) === null || _checkable$legendProp === void 0 ? void 0 : _checkable$legendProp.css)];
  var legend = hasCheckableConfig && checkable.legend ? (0, _react2.jsx)(_form_label.EuiFormLabel, (0, _extends2.default)({}, checkable.legendProps, {
    css: legendCssStyles,
    type: "legend"
  }), checkable.legend) : undefined;
  return checkable ? (0, _react2.jsx)("fieldset", (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    "aria-label": hasCheckableConfig ? checkable.ariaLegend : undefined
  }, rest), legend, children) : (0, _react2.jsx)("ul", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), _react.default.Children.map(children, function (child) {
    return (0, _react2.jsx)("li", null, child);
  }));
};