"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExternalLinkIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _react2 = require("@emotion/react");
var _excluded = ["target", "external"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * DRY util for indicating external links both via icon and to
 * screen readers. Used internally by at EuiLink and EuiListGroupItem
 */
var iconStyle = function iconStyle(_ref) {
  var euiTheme = _ref.euiTheme;
  return (0, _global_styling.logicalStyle)('margin-left', euiTheme.size.xs);
};
var EuiExternalLinkIcon = exports.EuiExternalLinkIcon = function EuiExternalLinkIcon(_ref2) {
  var target = _ref2.target,
    external = _ref2.external,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var iconCssStyle = (0, _services.useEuiMemoizedStyles)(iconStyle);
  var showExternalLinkIcon = target === '_blank' && external !== false || external === true;
  return (0, _react2.jsx)(_react.default.Fragment, null, showExternalLinkIcon && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_icon.EuiIcon, (0, _extends2.default)({
    css: iconCssStyle,
    size: "s",
    type: "popout",
    role: "presentation"
  }, rest)), target === '_blank' ? (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiExternalLinkIcon.newTarget.screenReaderOnlyText",
    default: "(external, opens in a new tab or window)"
  }))) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiExternalLinkIcon.externalTarget.screenReaderOnlyText",
    default: "(external)"
  }))))));
};