"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiListGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _list_group_item = require("./list_group_item");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _list_group = require("./list_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "listItems", "style", "flush", "bordered", "gutterSize", "wrapText", "maxWidth", "showToolTips", "color", "size", "ariaLabelledby"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 's', 'm'];
var EuiListGroup = exports.EuiListGroup = function EuiListGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    listItems = _ref.listItems,
    style = _ref.style,
    _ref$flush = _ref.flush,
    flush = _ref$flush === void 0 ? false : _ref$flush,
    _ref$bordered = _ref.bordered,
    bordered = _ref$bordered === void 0 ? false : _ref$bordered,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$wrapText = _ref.wrapText,
    wrapText = _ref$wrapText === void 0 ? false : _ref$wrapText,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$showToolTips = _ref.showToolTips,
    showToolTips = _ref$showToolTips === void 0 ? false : _ref$showToolTips,
    color = _ref.color,
    size = _ref.size,
    ariaLabelledby = _ref.ariaLabelledby,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var newStyle = style;
  if (maxWidth && maxWidth !== true) {
    newStyle = _objectSpread(_objectSpread({}, newStyle), (0, _global_styling.logicalStyle)('max-width', maxWidth));
  }
  var classes = (0, _classnames.default)('euiListGroup', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _list_group.euiListGroupStyles)(euiTheme);
  var cssStyles = [styles.euiListGroup, styles[gutterSize], flush && styles.flush, bordered && styles.bordered, maxWidth === true && styles.maxWidthDefault];
  var childrenOrListItems = null;
  if (listItems) {
    childrenOrListItems = listItems.map(function (item, index) {
      return [(0, _react2.jsx)(_list_group_item.EuiListGroupItem, (0, _extends2.default)({
        key: "title-".concat(index),
        showToolTip: showToolTips,
        wrapText: wrapText
        // we're passing the parent `color` and `size` down to the children
        // so that they can inherit it if they don't have one
        ,
        color: color,
        size: size
      }, item))];
    });
  } else {
    var showToolTipObj = showToolTips && {
      showToolTip: true
    };
    childrenOrListItems = _react.default.Children.map(children, function (child) {
      if ( /*#__PURE__*/_react.default.isValidElement(child)) {
        return (0, _services.cloneElementWithCss)(child, _objectSpread(_objectSpread({
          // we're passing the parent `color` and `size` down to the children
          // so that they can inherit it if they don't have one
          color: color,
          size: size
        }, showToolTipObj), child.props));
      }
    });
  }
  return (0, _react2.jsx)("ul", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    style: newStyle,
    "aria-labelledby": ariaLabelledby
  }, rest), childrenOrListItems);
};